<?php

namespace App\Exports;

use Illuminate\Http\Request;
use App\Models\Livraison;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStrictNullComparison;

class LivraisonExport implements FromCollection, WithHeadings, WithStrictNullComparison
{
    
    public function collection()
    {
        
            // Retrieve the selected orders and return them as a collection
            $selectedOrders = request()->input('selected_orders');
            if ($selectedOrders) {
                return Livraison::whereIn('id', $selectedOrders)->get(['city', 'name', 'COD', 'streetAddress', 'phone', 'description', 'noOpen']);
            }      
    

    }

    public function headings(): array
    {
        // Define the header row
        return ['city', 'name', 'COD', 'streetAddress', 'phone', 'description', 'noOpen'];
    }
}