<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Session;

class logoutInactiveUser
{
    public function handle($request, Closure $next)
    {
        if (Session::has('current_manager')) {
            $manager = \App\Models\User::find(session('current_manager')->id);
            $lastActivity = Session::get('last_activity');

            if ($lastActivity && time() - $lastActivity > 600) {
                session()->forget("current_manager");
                $log = new \App\Models\Log();
                $log->details = "Manager ".$manager->name." Logged out due to inactivity.";
                $log->user_id = $manager->id;
                $log->save();
                return redirect()->route('login')->with('success','Logged Out Due to Inactivity.');
            }
        }
        if(Session::has('current_employee')){
            $employee = \App\Models\User::find(session('current_employee')->id);
            $lastActivity = Session::get('last_activity');

            if ($lastActivity && time() - $lastActivity > 600) {
                session()->forget("current_employee");
                $log = new \App\Models\Log();
                $log->details = "Employee ".$employee->name." Logged out due to inactivity.";
                $log->user_id = $employee->id;
                $log->save();
                return redirect()->route('login')->with('success','Logged Out Due to Inactivity.');
            }
        }

        Session::put('last_activity', time());
        return $next($request);
    }
}
