<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Absence extends Model
{
    protected $fillable = [
        'employee_id', 'chantier_id', 'tache_id', 'category',
        'date_debut', 'date_fin', 'jours_absence',
        'type', 'statut', 'reason'
    ];
    
    protected $casts = [
        'date_debut' => 'date',
        'date_fin' => 'date'
    ];

    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id');
    }

    public function chantier()
    {
        return $this->belongsTo(Chantier::class);
    }

    public function tache()
    {
        return $this->belongsTo(Tache::class);
    }
}
