<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Tache;

class Chantier extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'adresse',
        'date_de_debut',
        'date_de_fin',
        'nbjours',
        'photo'
    ];

    // We don't need to cast photo as array since we're handling JSON encoding/decoding manually
    protected $casts = [];

    public function taches()
    {
        return $this->hasMany(Tache::class, 'chantier_id');
    }

    // Add accessor to handle photo JSON decoding
    public function getPhotoAttribute($value)
    {
        return $value ? json_decode($value) : null;
    }
}
