<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Chantier;

class Tache extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'date',
        'chantier_id',
        'nb_jours',
        'status',
        'photo',
        'employees',
        'date_debut',
        'date_fin',
        'description'
    ];

    public function chantier()
    {
        return $this->belongsTo(Chantier::class, 'chantier_id');
    }

    // Add accessor to handle photo JSON decoding
    public function getPhotoAttribute($value)
    {
        return $value ? json_decode($value) : null;
    }

    // Add accessor to handle employees JSON decoding
    public function getEmployeesAttribute($value)
    {
        return $value ? json_decode($value) : null;
    }
}
