<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('absences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreignId('chantier_id')->nullable()->references('id')->on('chantiers')->onDelete('set null');
            $table->foreignId('tache_id')->nullable()->references('id')->on('taches')->onDelete('set null');
            $table->enum('category', [
                'Arrêt maladie',
                'Absence injustifié',
                'Congé sans solde',
                'Autre'
            ]);
            $table->date('date_debut');
            $table->date('date_fin')->nullable();
            $table->string('jours_absence')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('absences');
    }
};
