<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDateRetourAndStatusToMaterielSalarieTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('materiel_salarie', function (Blueprint $table) {
            $table->date('date_retour')->nullable();
            $table->enum('status', ['assigned', 'returned'])->default('assigned');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('materiel_salarie', function (Blueprint $table) {
            $table->dropColumn('date_retour');
            $table->dropColumn('status');
        });
    }
}
