<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMaterielSalarieTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('materiel-salarie', function (Blueprint $table) {
            if (!Schema::hasColumn('materiel-salarie', 'date_retour')) {
                $table->date('date_retour')->nullable();
            }
            if (!Schema::hasColumn('materiel-salarie', 'status')) {
                $table->enum('status', ['assigned', 'returned'])->default('assigned');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('materiel-salarie', function (Blueprint $table) {
            $table->dropColumn('date_retour');
            $table->dropColumn('status');
        });
    }
}
