<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class UpdateStatusEnums extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // First, update any existing status values
        DB::statement("UPDATE `materiel-salarie` SET `status` = 'returned' WHERE `status` = 'indisponible'");
        
        // Then modify the enum
        DB::statement("ALTER TABLE `materiel-salarie` MODIFY COLUMN `status` ENUM('assigned', 'returned') NOT NULL DEFAULT 'assigned'");
        
        // For materiels table
        if (!Schema::hasColumn('materiels', 'status')) {
            Schema::table('materiels', function (Blueprint $table) {
                $table->enum('status', ['disponible', 'indisponible'])->default('disponible');
            });
        } else {
            DB::statement("ALTER TABLE `materiels` MODIFY COLUMN `status` ENUM('disponible', 'indisponible') NOT NULL DEFAULT 'disponible'");
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement("ALTER TABLE `materiel-salarie` MODIFY COLUMN `status` ENUM('assigned', 'returned') NOT NULL DEFAULT 'assigned'");
        
        if (Schema::hasColumn('materiels', 'status')) {
            Schema::table('materiels', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }
    }
}
