@extends('admin.layout')
@section('title') Ajouter Administrateur @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Ajouter Administrateur</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/admins">Administrateurs</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Administrateur
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>

<br>

<div class="row">
    
<div class="col-md-12">
    <div class="card">
        <div class="card-body">
            
            <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.add-admin') }}">
            @csrf
                <div class="form-group">
                    <label for="nom">Nom <strong class="text-danger">*</strong></label>
                    <input name="nom" id="nom" type="text" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="prenom">Prénom <strong class="text-danger">*</strong></label>
                    <input name="prenom" id="prenom" type="text" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="email">Email <strong class="text-danger">*</strong></label>
                    <input name="email" id="email" type="mail" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="password">Mot de passe <strong class="text-danger">*</strong></label>
                    <input name="password" id="password" type="password" class="form-control" required>
                </div>

                <button type="submit" class="btn btn-primary mr-2">Ajouter Administrateur</button>
                <button type="reset" class="btn btn-light">Réinitialiser</button>
                
            </form>
        </div>
    </div>
    </div>
</div>

@endsection