@extends('admin.layout')
@section('title') Modifier Métier @endsection
@section('content')




<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Ajouter salarié</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/manage-employees">Salariés</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Salarié
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.insert-employee') }}">
        @csrf
        <div class="form-group">
            <label for="exampleInputUsername1">Nom <strong class="text-danger">*</strong></label>
            <input name="nom" id="nom" type="text" class="form-control" id="exampleInputUsername1" required placeholder="Entre nom de salarié">
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Prénom <strong class="text-danger">*</strong></label>
            <input name="prenom" id="prenom" type="text" class="form-control" id="exampleInputUsername1" required placeholder="Entre prenom de salarié">
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Email <strong class="text-danger">*</strong></label>
            <input name="email" id="email" type="email" class="form-control" id="exampleInputUsername1" required placeholder="Entre email de salarié">
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Téléphone <strong class="text-danger">*</strong></label>
            <input name="phone" id="phone" type="text" class="form-control" id="exampleInputUsername1" required placeholder="Entre telephone de salarié">
        </div>


        <div class="form-group">
            <label for="password">Mot de passe <strong class="text-danger">*</strong></label>
            <input name="password" id="password" type="text" class="form-control"  placeholder="Veuillez entrez un mot de passe" required>
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Adresse</label>
            <input name="adresse" id="adresse" type="text" class="form-control" id="exampleInputUsername1" placeholder="Entre adresse de salarié">
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Métiers</label>
            <select id="primary_metiers" name="primary_metiers[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
            @foreach($metiers as $primary_metier)
                <option value="{{ $primary_metier->id ?? '' }}" >
                    {{ $primary_metier->nom }}
                </option>
            @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="exampleInputUsername1">Métiers secondaire</label>
            <select id="secondary_metiers" name="secondary_metiers[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
            @foreach($metiers as $secondary_metiers)
                <option value="{{ $secondary_metiers->id ?? '' }}" >
                    {{ $secondary_metiers->nom }}
                </option>
            @endforeach
            </select>
        </div>

        <div class="form-check">
            <label class="form-check-label ">
                <input type="checkbox" name="is_couvreur" id="is_couvreur" class="form-check-input">
                Couvreur
                <i class="input-helper"></i>
            </label>
        </div>

        <div class="form-group">
                <label for="photos">Photo</label>
                <div class="d-flex flex-wrap mb-2">
					<img id="logoPreview"  src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"
                    onclick="document.getElementById('photo-input').click();"/>
                </div>
            
            <input type="file" name="image" multiple class="image-preview-filepond filepond" id="photo-input" onchange="previewLogo(event)">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>

        <button type="submit" class="btn btn-primary mr-2">Ajouter</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>


@endsection
@section('script')

<script type="text/javascript">
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-employee", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>
<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>

<script>
    function previewLogo(event) {
		var output = document.getElementById('logoPreview');
		output.src = URL.createObjectURL(event.target.files[0]);
	}
</script>
@endsection