@extends('admin.layout')
@section('title') Ajouter Famille @endsection
@section('content')

<style>

.img-famille {
    width: auto;
}

</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Ajouter Famille</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/familles">Familles</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Famille
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.insert-famille') }}">
        @csrf
        <div class="form-group">
            <label for="nom">Nom Famille</label>
            <input name="nom" id="nom" type="text" class="form-control" required>
        </div>
        
        <div class="form-group">
            <label for="lieu">Lieu</label>
            <select id="lieuId" name="lieuId" class="form-control  w-100">
            <option value="" disabled selected>Choisir le lieu</option>
            @foreach($lieux as $lieu)
                <option value="{{ $lieu->id }}">{{ $lieu->lieu }}</option>
            @endforeach
            </select>
        </div>

        
        
        <div class="form-group">
        <input type="file" name="image[]" multiple class="image-preview-filepond filepond" id="photo-input">
        </div>
        
        <button type="submit" class="btn btn-primary mr-2">Ajouter</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

@endsection


@section('script')
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-famille rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
@endsection