@extends('admin.layout')
@section('title') Ajouter Métier @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Ajouter Métier</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/metiers">Métiers</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Métier
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.insert-metier') }}">
        @csrf
        <div class="form-group">
            <label for="nom">Nom Métier</label>
            <input name="nom" id="nom" type="text" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="salaries">Salariés</label>
            <br>
            <select id="employees" name="employees[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
            @foreach($employees as $employee)
                <option value="{{ $employee->id }}">{{ $employee->name }}</option>
            @endforeach
            </select>
        </div>


        <button type="submit" class="btn btn-primary mr-2">Ajouter</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>

        </form>
    </div>
</div>

@endsection