@extends('admin.layout')
@section('title') Add Product @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h3>Add Product</h3>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Product
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>


<div class="row">
	<div class="col-">
                    <div class="row match-height">
                        
                        <div class="col-md-12 col-12">
                            <div class="card">
                                <div class="card-content">
                                    <div class="card-body">
                                    
                                    
                                    
                                    
                                    
                                    <form action="{{ route('admin.insert-notification') }}" method="POST" enctype="multipart/form-data">
                                        @csrf


                                        <div class="col-md-3">
                                            <label class="jblack-text-color"><strong>Title</strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <div class="form-group has-icon-left">
                                                <div class="position-relative">
                                                <input type="text" class="form-control" 
                                                        placeholder="Alert Title"
                                                        name="title" id="title" required>
                                                    <div class="form-control-icon">
                                                        <i class="fa-solid fa-bell"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>



                                        <div class="col-md-3">
                                            <label for="type" class="jblack-text-color"><strong>Type</strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <div class="form-group has-icon-left">
                                                <div class="position-relative">
                                                    <fieldset class="form-control form-group">
                                                        <select class="form-select"  name="type" style="width:100%;" data-placeholder="Type" id="type" required>
                                                            <option value="info">Info</option>
                                                            <option value="danger">Danger</option>
                                                            <option value="warning">Warning</option>
                                                        </select>
                                                    </fieldset>
                                                    <div class="form-control-icon">
                                                        <i class="fa-regular fa-bell"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        


                                        <div class="col-md-3">
                                            <label for="end_date" class="jblack-text-color"><strong>End Date</strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <div class="form-group has-icon-left">
                                                <div class="position-relative">
                                                    <input type="date" class="form-control" id="end_date" name="end_date"
                                                        placeholder="Selling Price"  value="{{ date('d/m/Y') }}">
                                                        
                                                    <div class="form-control-icon">
                                                        <i class="fa-solid fa-clock"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        


                                        <div class="col-md-3">
                                            <label class="jblack-text-color"><strong>Message</strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <textarea class="form-control" id="content" name="content"></textarea>
                                        </div>
                                        


                                        <div class="col-md-3">
                                            <label class="jblack-text-color pt-2"><strong> Image </strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <div class="form-group has-icon-left">
                                                <div class="position-relative">
													
                                                    <div class="card-content">
													<div class="card-">
                                                        <input type="file" id="image" name="image" class="form-control image-preview-filepond">
													</div>
												</div>
                                                </div>
                                            </div>
                                        </div>
                                        



                                        <div class="col-md-3">
                                            <label for="employees" class="jblack-text-color"><strong>Select Employees</strong></label>
                                        </div>
                                        <div class="col-md-9" width="100%">
                                            <div class="form-group has-icon-left">
                                                <div class="position-relative">
                                                    
                                                    <fieldset class="form-control form-group">
                                                        <select id="employees" name="employees[]" class="choices form-select" multiple="multiple">
                                                        @foreach($employees as $employee)
                                                            <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                                        @endforeach
                                                        </select>
                                                    </fieldset>
                                                    <div class="form-control-icon">
                                                        <i class="fa-solid fa-list-check"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-check mb-3">
                                            <input type="checkbox" class="form-check-input" id="for_all_employees" name="for_all_employees"  value="1">
                                            <label class="form-check-label" for="for_all_employees">Send to All Employees</label>
                                        </div>

                                        <button type="submit" class="btn btn-primary">Create Notification</button>
                                    </form>


                                    







                                    



                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                <br><br>
	</div>
	
</div>


@endsection
@section('script')

<script src="{{ asset('assets/vendors/ckeditor/ckeditor.js') }}"></script>
    <script>
        ClassicEditor
            .create(document.querySelector('#description'))
            .catch(error => {
                console.error(error);
            });
    </script>
<!-- <script>
    CKEDITOR.replace('description');
</script> -->

<script>
    $('.drgpicker').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        showDropdowns: true,
        locale:
        {
          format: 'DD/MM/YYYY HH:mm'
        }
    });
</script>


<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>
<script>
        $(document).ready(function() {
            $('#for_all_employees').change(function() {
                if ($(this).is(':checked')) {
                    // Clear and disable the employees field if checked
                    $('#employees').val([]).prop('disabled', true);
                } else {
                    // Enable the employees field if unchecked
                    $('#employees').prop('disabled', false);
                }
            });
        });
    </script>
@endsection