@extends('admin.layout')
@section('title') Affectation Matériel Salarié @endsection
@section('content')

<style>

.img-materiel {
    width: auto;
}

</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Affectation Matériel Salarié</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/materiels">Matériels</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Affectation Matériel Salarié
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.insert-materiel-salarie') }}">
        @csrf
        
        <div class="form-group">
            <label for="salarie">Salarié</label>
            <select id="salarieId" name="salarieId" class="form-control  w-100">
            <option value="" disabled selected>Choisir le salarié</option>
            @foreach($salaries as $salarie)
                <option value="{{ $salarie->id }}">{{ $salarie->prenom ?? '' }} {{ $salarie->name ?? '' }}</option>
            @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="materiel">Matériel</label>
            <select id="materielId" name="materielId" class="form-control  w-100">
            <option value="" disabled selected>Choisir le matériel</option>
            @foreach($materiels as $materiel)
                @if($materiel->status == 'disponible')
                    <option value="{{ $materiel->id }}">{{ $materiel->materiel ?? '' }}</option>
                @endif
            @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="date_de_prise">Date de prise</label>
            <input name="date_de_prise" id="date_de_prise" type="date" min=0 class="form-control" required>
        </div>
        
        <div class="form-group">
            <label for="date_de_remise">Date de remise</label>
            <input name="date_de_remise" id="date_de_remise" type="date" min=0 class="form-control" required>
        </div>
        
        <button type="submit" class="btn btn-primary mr-2">Affecter</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

@endsection


@section('script')
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-materiel rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
@endsection