@extends('admin.layout')
@section('title') Gestion Chantiers @endsection
@section('content')




<div class="intro-y  mb-3 flex items-center">
    
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		<h2 class="mr-auto text-lg font-medium">Gestion des Chantiers</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				
				<a href="{{ route('admin.add-chantier') }}" class="btn btn-primary mr-2">Ajouter Chantier</a>
      
			</div>			 
		</div>

	</div>

</div>



     
<br>


        

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Adresse</th>
                    <th>Date de debut</th>
                    <th>Date de fin</th>
                    <th>Date fin Réelle</th>
                    <th>Enquête</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                @foreach($chantiers as $chantier)
	              <tr>
                    <td class="text-center">
                        @if($chantier->photo && !empty($chantier->photo) && isset($chantier->photo[0]) && file_exists(public_path('uploads/' . $chantier->photo[0])))
                            <img src="{{ asset('uploads/' . $chantier->photo[0]) }}" alt="Photo" class="rounded" height="200" width="200"/>
                        @else
                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="200" width="200"/>
                        @endif
                    </td>
	                <td class="font-weight-bold">
						<div class="mb-2">{{ $chantier->nom ?? '' }}</div>
						@php
							$nb_taches = \App\Models\Tache::where('chantier_id',$chantier->id)->count();;
						@endphp
						<div class="badge badge-warning text-white"><i class="fa-solid fa-list-check"></i> {{ $nb_taches ?? 0 }} taches</div>
					</td>
	                <td class="font-weight-bold">{{ $chantier->adresse ?? '' }}</td>
	                <td class="font-weight-bold">{{ $chantier->date_de_debut ?? '' }}</td>
	                <td class="font-weight-bold">{{ $chantier->date_de_fin ?? '' }}</td>
	                <td class="font-weight-bold">{{ $chantier->date_fin_reelle ?? 'N/A' }}</td>
	                <td>
                        @if(empty($chantier->date_fin_reelle))
                            <span class="badge badge-warning text-white"><i class="fa-solid fa-exclamation-circle"></i> Pas de date</span>
                        @else
                            @php
                                $difference = $chantier->nbjours - $chantier->nbjours_reelle;
                            @endphp
                    
                            @if($difference < 0)
                                
                                <span class="badge badge-danger text-white">
                                    <i class="fa-solid fa-circle-exclamation"></i> {{ $difference ?? '' }} jours de retard
                                </span>
                            @else
                                <span class="badge badge-success text-white">
                                    <i class="fa-solid fa-circle-check"></i> {{ $difference ?? '' }} jours en avance
                                </span>
                            @endif
                        @endif
                    </td>

	                
	                
	                <td>
					<a href='{{ route("admin.chantier-details", $chantier->id) }}' class="text-success mr-2"><i class="fa-solid fa-eye"></i> Details </a>
					<a href='{{ route("admin.edit-chantier", $chantier->id) }}' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="{{ $chantier->id }}" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-trash"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              @endforeach
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>



@endsection


@section('script')



<script type="text/javascript">
	$('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-chantier", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '{{ asset("assets/fr-FR.json") }}'
        },
        pageLength: 10, // Default number of rows per page
        lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
        buttons: [
            {
				title:'Liste des Chantiers',
                extend: 'copy',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'csv',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'excel',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Chantiers</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [ 1, 2, 3, 4, 5, 6]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
					
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


@endsection
