@extends('admin.layout')
@section('title') Comptabilité @endsection
@section('content')

<style>

.select2-container .select2-selection--single {
    min-height: 46px;
}
</style>

<div class="row">
    <div class="col-md-12 grid-margin">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">Statistiques de Travail des Employés</h4>

                <!-- Date Range and Chantier Filter Form -->
                <form method="GET" class="mb-4">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="start_date">Date de début</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" 
                                       value="{{ $start_date ?? '' }}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="end_date">Date de fin</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" 
                                       value="{{ $end_date ?? '' }}" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="chantier_id">Chantier (Optionnel)</label>
                                <select class="form-control select2 w-100" id="chantier_id" name="chantier_id">
                                    <option value="">Tous les chantiers</option>
                                    @foreach($chantiers as $chantier)
                                        <option value="{{ $chantier->id }}" {{ $chantier_id == $chantier->id ? 'selected' : '' }}>
                                            {{ $chantier->nom }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary d-block">Filtrer</button>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Display selected filters as a badge/label -->
                <div class="mb-4">
                    <h5>Filtres appliqués:</h5>
                    <div class="d-flex flex-wrap">
                        <div class="badge badge-info m-1 p-2">
                            Période: {{ \Carbon\Carbon::parse($start_date)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($end_date)->format('d/m/Y') }}
                        </div>
                        @if(isset($selectedChantier) && $selectedChantier)
                            <div class="badge badge-success m-1 p-2">
                                Chantier: {{ $selectedChantier->nom }}
                            </div>
                        @else
                            <div class="badge badge-secondary m-1 p-2">
                                Tous les chantiers
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Statistics Summary -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-striped table-borderless datatables" id="table1">
                                <thead>
                                    <tr>
                                        <th>Employé</th>
                                        <th>Jours de Travail Total</th>
                                        <th>Jours d'Absence</th>
                                        <th>Jours Réellement Travaillés</th>
                                        <th>Taux de Présence</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($employeeStats as $stat)
                                    <tr>
                                        <td>{{ $stat['name'] ?? '' }}</td>
                                        <td>{{ $stat['total_work_days'] ?? '' }}</td>
                                        <td>{{ $stat['total_absence_days'] ?? '' }}</td>
                                        <td>{{ $stat['real_worked_days'] ?? '' }}</td>
                                        <td>
                                            @if($stat['total_work_days'] > 0)
                                                {{ round(($stat['real_worked_days'] / $stat['total_work_days']) * 100, 1) }}%
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Statistics Charts -->
                <div class="row">
                    <!-- Work Days Distribution Chart -->
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Distribution des Jours de Travail
                                    @if(isset($selectedChantier) && $selectedChantier)
                                        - Chantier: {{ $selectedChantier->nom }}
                                    @endif
                                </h4>
                                <canvas id="workDaysChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-4">
                    <!-- Presence Rate Chart -->
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Taux de Présence par Employé
                                    @if(isset($selectedChantier) && $selectedChantier)
                                        - Chantier: {{ $selectedChantier->nom }}
                                    @endif
                                </h4>
                                <canvas id="presenceRateChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 for better dropdown UX
    $('.select2').select2({
        placeholder: "Sélectionner un chantier",
        allowClear: true
    });
});

document.addEventListener('DOMContentLoaded', function() {
    // Prepare data for charts
    const employeeStats = @json($employeeStats);
    const labels = employeeStats.map(stat => stat.name);
    
    // Work Days Distribution Chart
    new Chart(document.getElementById('workDaysChart'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [
                {
                    label: 'Jours de Travail Total',
                    data: employeeStats.map(stat => stat.total_work_days),
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                },
                {
                    label: 'Jours d\'Absence',
                    data: employeeStats.map(stat => stat.total_absence_days),
                    backgroundColor: 'rgba(255, 99, 132, 0.5)',
                },
                {
                    label: 'Jours Réellement Travaillés',
                    data: employeeStats.map(stat => stat.real_worked_days),
                    backgroundColor: 'rgba(75, 192, 192, 0.5)',
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Nombre de Jours'
                    }
                }
            }
        }
    });

    // Presence Rate Chart
    new Chart(document.getElementById('presenceRateChart'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Taux de Présence (%)',
                data: employeeStats.map(stat => 
                    stat.total_work_days > 0 
                        ? (stat.real_worked_days / stat.total_work_days * 100).toFixed(1) 
                        : 0
                ),
                backgroundColor: 'rgba(153, 102, 255, 0.5)',
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    max: 100,
                    title: {
                        display: true,
                        text: 'Taux de Présence (%)'
                    }
                }
            }
        }
    });
});
</script>

<script>
$('#table1').DataTable({
    dom: 'Bfrtip',
    language: {
        url: '{{ asset("assets/fr-FR.json") }}'
    },
    pageLength: -1, // Show all rows by default
    lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "Tous"] ], // "All" translated to "Tous"
    paging: false, // Disable pagination to show all rows
    info: false, // Hide info like "Showing 1 to 10 of 50 entries"
    searching: true, // Keep search functionality
    ordering: true, // Keep sorting functionality
    buttons: [
        {
            title: 'Statistiques de Travail des Employés: Entre {{ $start_date }} et {{ $end_date }}{{ isset($selectedChantier) && $selectedChantier ? " - Chantier: " . $selectedChantier->nom : "" }}',
            extend: 'copy',
            text: 'Copier',
            exportOptions: {
                columns: [0, 1, 2, 3, 4]
            }
        },
        {
            title: 'Statistiques de Travail des Employés: Entre {{ $start_date }} et {{ $end_date }}{{ isset($selectedChantier) && $selectedChantier ? " - Chantier: " . $selectedChantier->nom : "" }}',
            extend: 'csv',
            text: 'CSV',
            exportOptions: {
                columns: [0, 1, 2, 3, 4]
            }
        },
        {
            title: 'Statistiques de Travail des Employés: Entre {{ $start_date }} et {{ $end_date }}{{ isset($selectedChantier) && $selectedChantier ? " - Chantier: " . $selectedChantier->nom : "" }}',
            extend: 'excel',
            text: 'Excel',
            exportOptions: {
                columns: [0, 1, 2, 3, 4]
            }
        },
        {
            title: 'Statistiques de Travail des Employés: Entre {{ $start_date }} et {{ $end_date }}{{ isset($selectedChantier) && $selectedChantier ? " - Chantier: " . $selectedChantier->nom : "" }}',
            extend: 'pdf',
            text: 'PDF',
            orientation: 'landscape', // Better for wide tables
            pageSize: 'A4',
            exportOptions: {
                columns: [0, 1, 2, 3, 4]
            },
            customize: function(doc) {
                // Add header with date range and chantier
                let headerText = 'Statistiques de Travail des Employés\nPériode: {{ $start_date }} au {{ $end_date }}';
                
                @if(isset($selectedChantier) && $selectedChantier)
                    headerText += '\nChantier: {{ $selectedChantier->nom }}';
                @endif
                
                doc.content.splice(0, 0, {
                    text: headerText,
                    style: 'header',
                    alignment: 'center',
                    margin: [0, 0, 0, 20]
                });
                
                // Define styles
                doc.styles.header = {
                    fontSize: 16,
                    bold: true
                };
                
                // Style the table
                doc.defaultStyle.fontSize = 10;
                doc.styles.tableHeader.fontSize = 12;
                doc.styles.tableHeader.bold = true;
                doc.styles.tableHeader.alignment = 'center';
            }
        },
        {
            title: '<h2 style="text-align: center;">Statistiques de Travail des Employés<br>Période: {{ $start_date }} au {{ $end_date }}@if(isset($selectedChantier) && $selectedChantier)<br>Chantier: {{ $selectedChantier->nom }}@endif</h2>',
            extend: 'print',
            text: 'Imprimer',
            exportOptions: {
                columns: [0, 1, 2, 3, 4]
            },
            customize: function (win) {
                $(win.document.body)
                    .css('font-size', '10pt')
                    .prepend(
                        '<div style="text-align: center; margin-bottom: 30px;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 60%; margin-bottom: 20px;" /></div>'
                    );

                // Style the title
                $(win.document.body).find('h1')
                    .css('text-align', 'center')
                    .css('margin-bottom', '20px')
                    .css('font-size', '18pt');
                    
                // Style the table
                $(win.document.body).find('table')
                    .addClass('table table-bordered table-striped')
                    .css('width', '100%')
                    .css('margin', '0 auto');
                    
                // Style table headers
                $(win.document.body).find('table thead th')
                    .css('background-color', '#f8f9fa')
                    .css('font-weight', 'bold')
                    .css('text-align', 'center')
                    .css('border', '1px solid #dee2e6');
                    
                // Style table cells
                $(win.document.body).find('table tbody td')
                    .css('border', '1px solid #dee2e6')
                    .css('padding', '8px')
                    .css('text-align', 'center');
                    
                // Add footer with date
                $(win.document.body).append(
                    '<div style="margin-top: 30px; text-align: center; font-size: 9pt; color: #666;">' +
                    'Généré le: ' + new Date().toLocaleDateString('fr-FR') + ' à ' + new Date().toLocaleTimeString('fr-FR') +
                    '</div>'
                );
            }
        },
        {
            extend: 'colvis',
            text: 'Colonnes'
        }
    ],
    // Optional: Add custom styling for better appearance
    initComplete: function() {
        // Add custom styling to the wrapper
        $('.dataTables_wrapper').css('overflow-x', 'auto');
    }
});
</script>

<!-- Add summary statistics at the top -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Calculate overall statistics
    const employeeStats = @json($employeeStats);
    
    // Skip this if there are no employees
    if (employeeStats.length === 0) return;
    
    const totalWorkDays = employeeStats.reduce((sum, stat) => sum + stat.total_work_days, 0);
    const totalAbsenceDays = employeeStats.reduce((sum, stat) => sum + stat.total_absence_days, 0);
    const totalRealWorkedDays = employeeStats.reduce((sum, stat) => sum + stat.real_worked_days, 0);
    
    const overallPresenceRate = totalWorkDays > 0 
        ? ((totalRealWorkedDays / totalWorkDays) * 100).toFixed(1)
        : 'N/A';
    
    // Insert summary card before the table
    const summaryHtml = `
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title">Résumé Global</h5>
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="p-3">
                                <h3>${totalWorkDays}</h3>
                                <p>Jours de Travail Total</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="p-3">
                                <h3>${totalAbsenceDays}</h3>
                                <p>Jours d'Absence Total</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="p-3">
                                <h3>${totalRealWorkedDays}</h3>
                                <p>Jours Réellement Travaillés</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="p-3">
                                <h3>${overallPresenceRate}%</h3>
                                <p>Taux de Présence Global</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    `;
    
    // Insert summary card after the filters
    document.querySelector('.mb-4 + .row').insertAdjacentHTML('beforebegin', summaryHtml);
});
</script>
@endsection