@extends('admin.layout')
@section('title') Dashboard @endsection
<?php $user = \App\Models\User::find(session('current_admin')->id); ?>
@section('content')

          <div class="row">
            <div class="col-md-12 grid-margin">
              <div class="row">
                <div class="col-12 col-xl-8 mb-4 mb-xl-0">
                  <h3 class="font-weight-bold">Bonjour <?php echo $user->name ?></h3>
                  <h6 class="font-weight-normal mb-0">Bienvenue chez <span class="text-primary font-weight-bold">Renov'Immo</span>!</h6>
                </div>
              </div>
            </div>
          </div>

          <!-- KPI Cards Row -->
          <div class="row">
            <div class="col-md-3 mb-4 stretch-card transparent">
              <div class="card badge-warning text-white">
                <div class="card-body">
                  <p class="mb-4">Total Projets</p>
                  <p class="fs-30 mb-2">{{ $totalProjects ?? '' }}</p>
                  <p>Dont {{ $activeProjects ?? '' }} en cours</p>
                </div>
              </div>
            </div>

            <div class="col-md-3 mb-4 stretch-card transparent">
              <div class="card card-dark-blue">
                <div class="card-body">
                  <p class="mb-4">Tâches</p>
                  <p class="fs-30 mb-2">{{ $totalTasks ?? '' }}</p>
                  <p>{{ $completedTasks ?? '' }} terminées ({{ $taskCompletionRate ?? '' }}%)</p>
                </div>
              </div>
            </div>

            <div class="col-md-3 mb-4 stretch-card transparent">
              <div class="card card-light-blue">
                <div class="card-body">
                  <p class="mb-4">Employés</p>
                  <p class="fs-30 mb-2">{{ $totalEmployees ?? '' }}</p>
                  <p>Actifs</p>
                </div>
              </div>
            </div>

            <div class="col-md-3 mb-4 stretch-card transparent">
              <div class="card card-light-danger">
                <div class="card-body">
                  <p class="mb-4">Alertes Stock</p>
                  <p class="fs-30 mb-2">{{ count($lowStockElements) ?? '' }}</p>
                  <p>Éléments en stock bas</p>
                </div>
              </div>
            </div>


            <!-- <div class="col-md-2 mb-4 stretch-card transparent">
              <div class="card card-light-success">
                <div class="card-body">
                <p class="mb-4">Taux de Complétion</p>
                  <p class="fs-30 mb-2">{{ $taskCompletionRate }}%</p>
                  <p>Tâches terminées</p>
                </div>
              </div>
            </div> -->
          </div>

          

          <!-- Low Stock Alerts Section -->
          @if(count($lowStockElements) > 0)
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Alertes de Stock Bas</h4>
                  <div class="table-responsive">
                    <table class="table">
                      <thead>
                        <tr>
                          <th>Element</th>
                          <th>Quantité Actuelle</th>
                          <th>Seuil d'Alerte</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($lowStockElements as $element)
                        <tr>
                          <td>{{ $element->element ?? '' }}</td>
                          <td><span class="text-danger">{{ $element->quantity ?? '' }}</span></td>
                          <td>{{ $element->stock_alert ?? '' }}</td>
                          <td>
                            <a href="{{ route('admin.edit-element', ['id' => $element->id]) }}" class="btn btn-sm btn-primary">Modifier</a>
                          </td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
          @endif

          <!-- Charts Row 1 -->
          <div class="row">
            <!-- Monthly Projects Chart -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Distribution Mensuelle des Projets</h4>
                  <canvas id="monthlyProjectsChart"></canvas>
                </div>
              </div>
            </div>

            <!-- Task Status Distribution Chart -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Distribution des Tâches par Status</h4>
                  <canvas id="taskStatusChart"></canvas>
                </div>
              </div>
            </div>
          </div>

          <!-- Charts Row 2 -->
          <div class="row">
            <!-- Employee Workload Chart -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Charge de Travail par Employé</h4>
                  <canvas id="employeeWorkloadChart"></canvas>
                </div>
              </div>
            </div>

            <!-- Task Completion Trend Chart -->
            <div class="col-md-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Tendance de Complétion des Tâches (7 derniers jours)</h4>
                  <canvas id="taskCompletionTrendChart"></canvas>
                </div>
              </div>
            </div>
            
            
            
            
            
          </div>

          <!-- Upcoming Projects Table -->
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Projets à Venir</h4>
                  <div class="table-responsive">
                    <table class="table table-hover">
                      <thead>
                        <tr>
                          <th>Projet</th>
                          <th>Date de Début</th>
                          <th>Date de Fin</th>
                          <th>Durée (Jours)</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($upcomingProjects as $project)
                        <tr>
                          <td>{{ $project['nom'] ?? '' }}</td>
                          <td>{{ \Carbon\Carbon::parse($project['debut'])->format('d/m/Y') ?? '' }}</td>
                          <td>{{ \Carbon\Carbon::parse($project['fin'])->format('d/m/Y') ?? '' }}</td>
                          <td>{{ $project['duree'] ?? '' }}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <!-- Active Projects Progress -->
          <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Progression des Projets en Cours</h4>
                  <div class="table-responsive">
                    <table class="table table-hover">
                      <thead>
                        <tr>
                          <th>Projet</th>
                          <th>Progression</th>
                          <th>Tâches Terminées</th>
                        </tr>
                      </thead>
                      <tbody>
                        @foreach($ongoingProjects as $project)
                        <tr>
                          <td>{{ $project['name'] ?? '' }}</td>
                          <td>
                            <div class="progress">
                              <div class="progress-bar bg-success" role="progressbar" 
                                   style="width: {{ $project['progress'] ?? '' }}%" 
                                   aria-valuenow="{{ $project['progress'] ?? '' }}" 
                                   aria-valuemin="0" 
                                   aria-valuemax="100">
                                {{ $project['progress'] ?? '' }}%
                              </div>
                            </div>
                          </td>
                          <td>{{ $project['completed_tasks'] ?? '' }}/{{ $project['total_tasks'] ?? '' }}</td>
                        </tr>
                        @endforeach
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>

@endsection

@section('script')
  <!-- Include Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  
  <script>
    const ctx = document.getElementById('delaysPieChart').getContext('2d');

    const data = {
        labels: ['Respect des délais', 'Retards'],
        datasets: [{
            label: 'Taux de respect des délais',
            data: [{{ $onTimeChantiers }}, {{ $lateChantiers }}],
            backgroundColor: ['#28a745', '#dc3545'], // Green and Red
            hoverOffset: 4
        }]
    };

    const config = {
        type: 'pie',
        data: data,
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const label = context.label || '';
                            const value = context.raw || 0;
                            const total = {{ $totalChantiers }};
                            const percentage = total > 0 ? ((value / total) * 100).toFixed(2) : 0;
                            return `${label}: ${value} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    };

    new Chart(ctx, config);
</script>
  
  <script>
    document.addEventListener('DOMContentLoaded', function() {
        
        
        // Monthly Projects Chart
        new Chart(document.getElementById('monthlyProjectsChart'), {
            type: 'bar',
            data: {
                labels: ['Jan', 'Fév', 'Mar', 'Avr', 'Mai', 'Jun', 'Jul', 'Aoû', 'Sep', 'Oct', 'Nov', 'Déc'],
                datasets: [{
                    label: 'Projets par Mois',
                    data: @json(array_values($monthlyProjects)),
                    backgroundColor: 'rgba(75, 192, 192, 0.2)',
                    borderColor: 'rgba(75, 192, 192, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });

        // Task Status Distribution Chart
        new Chart(document.getElementById('taskStatusChart'), {
            type: 'pie',
            data: {
                labels: Object.keys(@json($taskStatusDistribution)),
                datasets: [{
                    data: Object.values(@json($taskStatusDistribution)),
                    backgroundColor: [
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(54, 162, 235, 0.2)'
                    ],
                    borderColor: [
                        'rgba(75, 192, 192, 1)',
                        'rgba(255, 99, 132, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(54, 162, 235, 1)'
                    ],
                    borderWidth: 1
                }]
            }
        });

        // Employee Workload Chart
        new Chart(document.getElementById('employeeWorkloadChart'), {
            type: 'bar',
            data: {
                labels: @json($employeeWorkload->pluck('name')),
                datasets: [{
                    label: 'Tâches en cours',
                    data: @json($employeeWorkload->pluck('tasks_count')),
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });

        // Task Completion Trend Chart
        new Chart(document.getElementById('taskCompletionTrendChart'), {
            type: 'line',
            data: {
                labels: Object.keys(@json($taskCompletionTrend)).map(date => {
                    return new Date(date).toLocaleDateString('fr-FR');
                }),
                datasets: [{
                    label: 'Tâches terminées',
                    data: Object.values(@json($taskCompletionTrend)),
                    fill: false,
                    borderColor: 'rgb(75, 192, 192)',
                    tension: 0.1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    });
  </script>
@endsection