@extends('admin.layout')
@section('title') Modifier Comptabilité @endsection
@section('content')
<div class="row">
    <div class="col-lg-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title">Modifier Comptabilité</h4>
                    <a href="{{ route('admin.comptabilite') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Retour
                    </a>
                </div>

                <form class="forms-sample" method="POST" action="{{ route('admin.update-absence') }}">
                    @csrf
                    <input type="hidden" name="absence_id" value="{{ $absence->id }}">
                    <input type="hidden" name="employee_id" value="{{ $absence->employee_id }}">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="employee_id">Salarié</label>
                                <h4 class="font-weight-bold">{{ $absence->employee->prenom ?? '' }} {{ $absence->employee->name ?? '' }}</h4>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                            <label for="category">Catégorie</label>
                            <select class="form-control" name="category" id="category" required>
                                <option value="" disabled>Sélectionner une catégorie</option>
                                <option value="Arrêt maladie" {{ trim($absence->category) == 'Arrêt maladie' ? 'selected' : '' }}>Arrêt maladie</option>
                                <option value="Absence injustifié" {{ trim($absence->category) == 'Absence injustifié' ? 'selected' : '' }}>Absence injustifié</option>
                                <option value="Congé sans solde" {{ trim($absence->category) == 'Congé sans solde' ? 'selected' : '' }}>Congé sans solde</option>
                                <option value="Autre" {{ trim($absence->category) == 'Autre' ? 'selected' : '' }}>Autre</option>
                            </select>
                        </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date">Date de debut</label>
                                <input type="date" class="form-control" name="date_debut" value="{{ $absence->date_debut->format('Y-m-d') ?? '' }}" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="date">Date de fin</label>
                                <input type="date" class="form-control" name="date_fin" value="{{ $absence->date_fin->format('Y-m-d') ?? '' }}" required>
                            </div>
                        </div>

                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary mr-2">
                            <i class="fas fa-save"></i> Enregistrer
                        </button>
                        <a href="{{ route('admin.comptabilite') }}" class="btn btn-light">
                            <i class="fas fa-times"></i> Annuler
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
@endif

@if($errors->any())
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <ul class="mb-0">
        @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
@endif
@endsection

@section('script')
<script>
$(document).ready(function() {
    // Initialize select2 if you're using it
    if ($.fn.select2) {
        $('select[name="employee_id"]').select2({
            placeholder: "Sélectionner un salarié",
            width: '100%'
        });
    }
});
</script>
@endsection