@extends('admin.layout')
@section('title') Modifier Element @endsection
@section('content')


<style>

.img-element {
    width: auto;
}
</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Modifier Element</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/elements">Elements</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ajouter Element
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-element') }}">
        @csrf
        <input type="hidden" name="id" value="{{ $element->id }}">
        <div class="form-group">
            <label for="element">Element</label>
            <input name="element" id="element" value="{{ $element->element ?? '' }}" type="text" class="form-control" required>
        </div>

        <div class="form-group">
            <label for="familleId">Famille</label>
            <select id="familleId" name="familleId" class="form-control  w-100">
            <option value="" disabled selected>Choisir la famille</option>
            @foreach($familles as $famille)
                <option value="{{ $famille->id }}" <?= ($element->familleId == $famille->id)?'selected':''; ?>>{{ $famille->nom ?? '' }}</option>
            @endforeach
            </select>
        </div>

        <div class="form-group">
            <label for="stock_alert">Seuil d'alerte stock</label>
            <input name="stock_alert" id="stock_alert" type="number" min="0" value="{{ $element->stock_alert ?? '' }}" class="form-control" >
        </div>

        <div class="form-group">
            <label for="quantity">Quantité</label>
            <input name="quantity" id="quantity" value="{{ $element->quantity ?? '' }}" type="number" step="1" min="0"  class="form-control" required>
        </div>
        
        
        <div class="form-group">
            <label for="prix_achat">Prix D'achat</label>
            <div class="input-group">
                <div class="input-group-prepend">
                <span class="input-group-text bg-primary text-white">€</span>
                </div>
                <input name="prix_achat" id="prix_achat" type="number" step="0.01" min="0.01" class="form-control" value="{{ $element->prix_achat ?? '' }}" aria-label="Prix d'achat en EUR">
                
            </div>
        </div>

        <!--<div class="form-group">-->
        <!--    <label for="prix">Prix</label>-->
        <!--    <input name="prix" id="prix" value="{{ $element->prix }}" type="text" class="form-control" required>-->
        <!--</div>-->

        <div class="form-group">
                <label for="photos">Image</label>
                <div class="d-flex flex-wrap mb-2">
                    
						@if($element->photo)
							@php $photos = json_decode($element->photo); @endphp
                            @if(!empty($photos))

                                @foreach($photos as $photo)

                                    @if( file_exists(public_path('uploads/' . $photo)) )
                                        <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                                    @endif
                                @endforeach
                            @endif
						@else
							<img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"/>
						@endif
                </div>
            
            <input type="file" name="photo[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>


            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

@endsection



@section('script')
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-element rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
@endsection