@extends('admin.layout')
@section('title')Modifier Métier @endsection
@section('content')
<div class="intro-y mt-8 flex items-center">
    <h2 class="mr-auto text-lg font-medium">Mettre a jour Metier</h2>
</div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-metier') }}">
        @csrf
            <input type="hidden" name="metier" value="{{ $metier->id }}">
            <div class="form-group">
                <label for="exampleInputUsername1">Nom Métier</label>
                <input name="nom" id="nom" type="text" class="form-control"  value="{{ $metier->nom ?? '' }}" required>
            </div>

            <div class="form-group">
                <label for="salaries">Salariés</label>
                <br>
                <select id="employees" name="employees[]" class="js-example-basic-multiple form-control  w-100" multiple="multiple">
                @foreach($employees as $employee)
                    <option value="{{ $employee->id ?? '' }}" 
                        <?php echo (in_array($employee->id, json_decode($metier->employees) ?? [])) ? 'selected' : ''; ?>>
                        {{ $employee->name }}
                    </option>
                @endforeach
                </select>
            </div>
            
            <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
            <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>


@endsection