@extends('admin.layout')
@section('title') Modifier Chantier @endsection
@section('content')


<style>

.img-chantier {
    width: auto;
}
</style>



<div class="intro-y mb-3 flex items-center">
        
        <div class="row">
            <div class="col-4 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Modifier Tache</h2>
            </div>

            <div class="col-4">
                <div class="justify-content-end d-flex">
                    
        
                </div>			 
            </div>
            <div class="col-4 mb-6 mb-xl-0">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/admin/chantiers">Chantiers</a></li>
                    <li class="breadcrumb-item"><a href="/admin/chantier-details/{{ $tache->chantier->id }}">Détail du Chantier</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Modifier Tache
                    </li>
                </ol>
            </nav>
        </div>


        </div>

    </div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="{{ route('admin.update-tache-chantier') }}">
        @csrf
        <input type="hidden" name="id" value="{{ $tache->id }}">
       
        <div class="form-group">
            <label for="nom">Tache</label>
            <input name="nom" id="nom" type="text" value="{{ $tache->nom ?? '' }}" class="form-control" required>
        </div>
        
        <div class="form-group">
            <label for="description">Description</label>
            <textarea name="description" id="description" class="form-control" rows="3">{{ $tache->description ?? '' }}</textarea>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="date_debut">Date de début</label>
                    <input name="date_debut" id="date_debut" type="date" class="form-control" value="{{ $tache->date_debut ?? '' }}" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="date_fin">Date de fin</label>
                    <input name="date_fin" id="date_fin" type="date" class="form-control" value="{{ $tache->date_fin ?? '' }}" required>
                </div>
            </div>
        </div>
        
        
        <div class="form-group">
            <label for="status">Statut</label>
            <select id="status" name="status" class="form-control mb-3">
                <option value="pending" <?= ($tache->status == "pending")?'selected':''; ?>>En Attente</option>
                <option value="in_progress" <?= ($tache->status == "in_progress")?'selected':''; ?>>En Cours</option>
                <option value="completed" <?= ($tache->status == "completed")?'selected':''; ?>>Complété</option>
            </select>
        </div>


        <div class="form-group">
            <label for="salaries">Salariés</label>
            <br>
            <select id="employees" name="employees[]" class="js-example-basic-multiple form-control w-100" multiple="multiple">
                @php
                    $selectedEmployees = is_array($tache->employees) ? $tache->employees : json_decode($tache->employees, true);
                @endphp
                @foreach($employees as $employee)
                    <option value="{{ $employee->id ?? '' }}" 
                        {{ in_array($employee->id, $selectedEmployees ?? []) ? 'selected' : '' }}>
                        {{ $employee->name }}
                    </option>
                @endforeach
            </select>
        </div>
        


        <div class="form-group">
            <label for="photos">Photos</label>
            <div class="d-flex flex-wrap mb-2">
                @if($tache->photo)
                    @php
                        $photos = is_array($tache->photo) ? $tache->photo : json_decode($tache->photo, true);
                    @endphp
                    @if(!empty($photos))
                        @foreach($photos as $photo)
                            @if(file_exists(public_path('uploads/' . $photo)))
                                <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                            @else
                                <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                            @endif
                        @endforeach
                    @else
                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"/>
                    @endif
                @else
                    <img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="rounded" height="200" width="auto"/>
                @endif
            </div>

            <input type="file" name="photos[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>



            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>

    </div>
</div>

@endsection



@section('script')
<script>

$(document).ready(function() {
    $('input[name="date_debut"]').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('input[name="date_fin"]');
        
        // Set minimum end date to start date
        endDateInput.attr('min', startDate);
        
        // If end date is before start date, update it
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('input[name="date_fin"]').on('change', function() {
        const endDate = this.value;
        const startDate = $('input[name="date_debut"]').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

    // Date validation for filter form
    $('input[name="date_debut"]').on('change', function() {
        const startDate = this.value;
        const endDateInput = $('input[name="date_fin"]');
        
        endDateInput.attr('min', startDate);
        
        if (endDateInput.val() && endDateInput.val() < startDate) {
            endDateInput.val(startDate);
        }
    });
    
    $('input[name="date_fin"]').on('change', function() {
        const endDate = this.value;
        const startDate = $('input[name="date_debut"]').val();
        
        if (startDate && endDate < startDate) {
            this.setCustomValidity('La date de fin doit être après la date de début');
            this.reportValidity();
            return false;
        } else {
            this.setCustomValidity('');
        }
    });

});

    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-chantier rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
@endsection