@extends('admin.layout')
@section('title') Logs Report @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<center>
				<span class="text-primary" style="font-size:25px;"><i class="fa-solid fa-clipboard-list"></i>&nbsp;&nbsp;Logs Report</span>
			</center>
		</div>
	</div>
</div>
<br><br>
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<table class="table  datatables" id="dataTable">
	      <thead>
	        <tr>
	          <th>#</th>
	          <th>Details</th>
	          <th>User</th>
	          <th>Date & Time</th>
	        </tr>
	      </thead>
	      <tbody>
	      	<?php $i= 1; ?>
	        @foreach($logs->sortByDesc('id') as $log)
	        <?php
	        $user = \App\Models\User::find($log->user_id);
	         ?>
	        <tr>
	          <td>{{ $i++ }}</td>
	          <td>{{ $log->details }}</td>
	          <td>{{ $user->name }}</td>
	          <td>{{ $log->created_at }}</td>
	        </tr>
	        @endforeach
	      </tbody>
	    </table>
		</div>
	</div>
</div>
@endsection
@section('script')

<script>
  $('#dataTable').DataTable({
      dom: 'lBfrtip',
      autoWidth: true,
      buttons: [
        { extend: 'copy', className: 'btn btn-sm btn-primary' },
        { extend: 'excel', className: 'btn btn-sm btn-primary' },
        { extend: 'csv', className: 'btn btn-sm btn-primary' },
        { extend: 'pdf', className: 'btn btn-sm btn-primary' },
        { extend: 'print', className: 'btn btn-sm btn-primary' }
      ],
      lengthMenu: [
        [16, 32, 64, -1],
        [16, 32, 64, "All"]
      ],
    });
</script>
@endsection