@extends('admin.layout')
@section('title') Gestion des Lieux @endsection
@section('content')



<div class="intro-y  mb-3 flex items-center">
	<div class="row">

		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Lieux</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="{{ route('admin.add-lieu') }}" class="btn btn-primary mr-2">Ajouter lieu</a>
			</div>			 
		</div>

	</div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Lieu</th>
                    <th style="text-align:right;">Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                @foreach($lieux as $lieu)
	              <tr>
	                <td>{{ $i++ }}</td>
                    <td>
                        @if($lieu->photo)
							@php $photos = json_decode($lieu->photo); @endphp
							@if(!empty($photos) && isset($photos[0]) && file_exists(public_path('uploads/' . $photos[0])))
								<img src="{{ asset('uploads/' . $photos[0]) }}" alt="Photo" class="img-fluid rounded" height="200" width="auto"/>
							@else
								<img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="img-fluid rounded" height="200" width="auto"/>
							@endif
						@else
							<img src="{{ asset('assets/images/no_image.png') }}" alt="No Images" class="img-fluid rounded" height="200" width="auto"/>
						@endif
                    </td>
	                <td class="font-weight-bold">{{ $lieu->lieu ?? '' }}</td>

	                <td style="text-align:right;">
					<a href='{{ route("admin.edit-lieu",$lieu->id) }}' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="{{ $lieu->id }}" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-pen-to-square"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              @endforeach
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

@endsection


@section('script')



<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("{{ route('admin.delete-lieu', ['id' => 'dataId']) }}".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>


<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '{{ asset("assets/fr-FR.json") }}'
        },
        pageLength: 10, // Default number of rows per page
        lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
        buttons: [
            {
				title:'Liste des Lieux',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2]
                }
            },
            {
				title:'Liste des Lieux',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 2]
                }
            },
            {
				title:'Liste des Lieux',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 2]
                }
            },
            {
				title:'Liste des Lieux',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 2]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Lieux</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 2]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');

				}
			},

            'colvis'
        ]
    });
</script>

@endsection