@extends('admin.layout')
@section('title') Logs Report @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h3>Logs Report</h3>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="./">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Logs Report
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<table class="table  datatables" id="dataTable">
	      <thead>
	        <tr>
	          <th>#</th>
	          <th>Details</th>
	          <th>User</th>
	          <th>Actions</th>
	        </tr>
	      </thead>
	      <tbody>
	      	<?php $i= 1; ?>
	        @foreach($logs as $log)
	        <?php
	        $user = \App\Models\User::find($log->user_id);
	         ?>
	        <tr>
	          <td>{{ $i++ }}</td>
	          <td>{{ $log->details }}</td>
	          <td>{{ $user->name ?? ''}}</td>
	          <td>
			  <a class="btn btn-danger rounded-pill delete" {{ $log->id }}" href="javascript::void();"><i class="fa-solid fa-trash mr-2"></i> Remove</a>
	          </td>
	        </tr>
	        @endforeach
	      </tbody>
	    </table>
		</div>
	</div>
</div>
@endsection
@section('script')
<script type="text/javascript">
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-log", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>
<script>
  $('#dataTable').DataTable({
      dom: 'lBfrtip',
      autoWidth: true,
      buttons: [
        { extend: 'copy', className: 'btn btn-sm btn-primary' },
        { extend: 'excel', className: 'btn btn-sm btn-primary' },
        { extend: 'csv', className: 'btn btn-sm btn-primary' },
        { extend: 'pdf', className: 'btn btn-sm btn-primary' },
        { extend: 'print', className: 'btn btn-sm btn-primary' }
      ],
      lengthMenu: [
        [16, 32, 64, -1],
        [16, 32, 64, "All"]
      ],
    });
</script>
@endsection