@extends('admin.layout')
@section('title') Gestion des Salariés @endsection
@section('content')


<div class="intro-y  mb-3 flex items-center">
    
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		<h2 class="mr-auto text-lg font-medium">Gestion des Salariés</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				
				<a href="{{ route('admin.add-employee') }}" class="btn btn-primary mr-2">Ajouter Salarié</a>
      
			</div>			 
		</div>

	</div>

</div>


<br>



<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th>#</th>
                    <th>Image</th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Email</th>
                    <th>Téléphone</th>
                    <th>Métiers</th>
                    <th>Métiers secondaire</th>
                    <th></th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                @foreach($employees as $employee)
	              <tr>
	                <td>{{ $i++ }}</td>
					<td>
					@if($employee->image)
					<img src="{{ asset('media/' . $employee->image) }}"
					style="width:50px; height:auto;">
					@else
					<img id="logoprv" src="{{ asset('assets/images/RenovImmo-FOND-BLANC.jpg') }}"
						style="width:50px; height:auto;">                                                            
					@endif
					@if($employee->is_couvreur)
					<p><div class="badge badge-success text-small">Couvreur</div></p>
					@endif
					</td>
	                <td class="font-weight-medium">{{ $employee->name }}</td>
	                <td class="font-weight-medium">{{ $employee->prenom }}</td>
	                <td class="font-weight-bold">{{ $employee->email }}</td>
	                <td class="font-weight-medium"><div class="badge badge-success">{{ $employee->phone }}</div></td>
	                <td class="font-weight-medium">
					
						@if(!empty($employee->primary_metiers))
						@php
						$primary_metiers = json_decode($employee->primary_metiers);
						foreach($primary_metiers as $primary_met){
							$primary_met = \App\Models\Metier::find($primary_met); 
							if($primary_met)
							echo "<span class='badge badge-primary text-white mr-1'>".$primary_met->nom."<span class='text-primary'>,</span></span> ";
						}
						
						@endphp
						@endif
					</td>
	                <td>
					
						@if(!empty($employee->secondary_metiers))
						@php
						$secondary_metiers = json_decode($employee->secondary_metiers);
						foreach($secondary_metiers as $secondary_met){
							$secondary_met = \App\Models\Metier::find($secondary_met);
							if($secondary_met) 
							echo "<span class='badge badge-primary text-white mr-1'>".$secondary_met->nom."<span class='text-primary'>,</span></span> ";
						}
						
						@endphp
						@endif
					</td>
	                
	                <td>
					<a href='{{ route("admin.edit-employee",$employee->id) }}' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="{{ $employee->id }}" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-trash"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              @endforeach
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>




@endsection
@section('script')


<script type="text/javascript">
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-employee", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  	$('#table1').DataTable({
		dom: 'Bfrtip',
		language: {
			url: '{{ asset("assets/fr-FR.json") }}'
		},
		pageLength: -1, // Show all rows by default
		lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "Tous"] ], // "All" translated to "Tous"
		paging: false, // Disable pagination to show all rows
		info: false, // Hide info like "Showing 1 to 10 of 50 entries"
		searching: true, // Keep search functionality
		ordering: true, // Keep sorting functionality
        buttons: [
            {
				title:'Liste des Salariés',
                extend: 'copy',
                exportOptions: {
                    columns: [ 2, 3, 4, 5, 6, 7]
                }
            },
            {
				title:'Liste des Salariés',
                extend: 'csv',
                exportOptions: {
                    columns: [ 2, 3, 4, 5, 6, 7]
                }
            },
            {
				title:'Liste des Salariés',
                extend: 'excel',
                exportOptions: {
                    columns: [ 2, 3, 4, 5, 6, 7]
                }
            },
            {
				title:'Liste des Salariés',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [ 2, 3, 4, 5, 6, 7]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Salariés</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [ 2, 3, 4, 5, 6, 7]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
					
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>

@endsection