@extends('admin.layout')
@section('title') Manage Managers @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<center>
				<span class="text-primary" style="font-size:25px;"><i class="fa-solid fa-chalkboard-user"></i>&nbsp;&nbsp;Manage Managers</span>
			</center>
		</div>
	</div>
</div>
<br><br>
<div class="row">
	<div class="col-md-4">
		<div class="card p-2">
			<div class="card-header">
				<strong class="card-title"><i class="fa-solid fa-plus"></i> Add Manager</strong>
			</div>
			<div class="card-body">
				<form method="post" action="{{ route('admin.add-manager') }}">
					@csrf
					<div class="form-group mb-3">
          	<label for="name">Full Name</label>
          	<input id="name" name="name" class="form-control" placeholder="Full Name" required>
          </div>
          <div class="form-group mb-3">
          	<label for="email">Email</label>
          	<input type="email" id="email" name="email" class="form-control" placeholder="Email" required>
          </div>
          <div class="form-group mb-3">
              <label for="phone">Phone Number</label>
              <input id="phone" name="phone" class="form-control" placeholder="Phone Number" required>
          </div>
          <div class="form-group mb-3">
              <label for="password">Password</label>
              <input type="password" id="password" name="password" class="form-control" placeholder="Password" required>
          </div>
          <button type="submit" class="btn btn-primary btn-block"><i class="fa-solid fa-plus"></i> Add Manager</button>
				</form>
			</div>
		</div>
		<br><br>
	</div>
	<div class="col-md-8">
		<div class="card shadow">
	        <div class="card-body">
	          <!-- table -->
	          <table class="table datatables" id="dataTable">
	            <thead>
	              <tr>
	                <th>#</th>
	                <th>Name</th>
	                <th>Phone</th>
	                <th>Email</th>
	                <th>Action</th>
	              </tr>
	            </thead>
	            <tbody>
	            	<?php $i= 1; ?>
	              @foreach($managers as $manager)
	              <tr>
	                <td>{{ $i++ }}</td>
	                <td>{{ $manager->name }}</td>
	                <td>{{ $manager->phone }}</td>
	                <td>{{ $manager->email }}</td>
	                <td><button class="btn btn-sm dropdown-toggle more-horizontal" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
	                    <span class="text-muted sr-only">Action</span>
	                  </button>
	                  <div class="dropdown-menu dropdown-menu-right">
	                    <a class="dropdown-item" href='{{ route("admin.edit-manager",$manager->id) }}'>Edit</a>
	                    <a class="dropdown-item delete" data-id="{{ $manager->id }}" href="javascript::void();" >Remove</a>
	                    <a class="dropdown-item" href="{{ route('admin.manager-login',$manager->id) }}" target="_blank">Login as Manager</a>
	                    <a class="dropdown-item" href="{{ route('admin.add-message',$manager->id) }}">Message Manager</a>
	                  </div>
	                </td>
	              </tr>
	              @endforeach
	            </tbody>
	          </table>
	        </div>
	    </div>
	</div>
</div>
<script>
  $('#dataTable').DataTable(
  {
    autoWidth: true,
    "lengthMenu": [
      [16, 32, 64, -1],
      [16, 32, 64, "All"]
    ]
  });
</script>
<script type="text/javascript">
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`{{ route("admin.delete-manager", [":dataId"]) }}`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>
<script>
  $(document).ready(function () {
    $('#dataTable').DataTable({
      dom: 'lBfrtip',
      autoWidth: true,
      buttons: [
        { extend: 'copy', className: 'btn btn-sm btn-primary' },
        { extend: 'excel', className: 'btn btn-sm btn-primary' },
        { extend: 'csv', className: 'btn btn-sm btn-primary' },
        { extend: 'pdf', className: 'btn btn-sm btn-primary' },
        { extend: 'print', className: 'btn btn-sm btn-primary' }
      ],
      lengthMenu: [
        [16, 32, 64, -1],
        [16, 32, 64, "All"]
      ],
    });
  });
</script>
@endsection