@extends('admin.layout')
@section('title') Gestion des Matériels @endsection
@section('content')

<div class="intro-y  mb-3 flex items-center">
	<div class="row">

		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Matériels</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="{{ route('admin.add-materiel') }}" class="btn btn-primary mr-2">Ajouter Matériel</a>
				<a href="{{ route('admin.affectation-materiel-salarie') }}" class="btn btn-primary mr-2">Affectation Salarié</a>
			</div>			 
		</div>

	</div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Référence</th>
                    <th>Matériel</th>
                    <th>Prix d'achat</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                @foreach($materiels as $materiel)
				@if($materiel->status == 'disponible')
				<tr>
	                <td>{{ $i++ }}</td>
                    <td>
                        @if($materiel->photo)
                        @php $photos = json_decode($materiel->photo); @endphp
                            @if(!empty($photos))
                                @foreach($photos as $photo)
                                    @if(file_exists(public_path('uploads/' . $photo)))
                                        <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded" height="50" width="50"/>
                                        @break
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                        @break
                                    @endif
                                @endforeach
                            @else
                                <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                            @endif
                        @else
                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                        @endif
                    </td>
					
                    <td class="font-weight-bold">
					@if($materiel->reference)
						{{ $materiel->reference ?? '' }}
						@else
						<span class="text-muted">Aucun</span>
						@endif
					</td>
	                <td class="font-weight-bold">{{ $materiel->materiel ?? '' }}</td>
	                <td class="font-weight-bold">€ {{ $materiel->prix_achat ?? '' }}</td>
	                
	                <td class="font-weight-bold">
						@if($materiel->status == 'disponible')
						<span class="badge bg-success text-white">{{ $materiel->status ?? '' }}</span>
						@else
						<span class="badge bg-danger text-white">{{ $materiel->status ?? '' }}</span>
						@endif
					</td>
	                <td>
    					<a href='{{ route("admin.edit-materiel",$materiel->id) }}' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
    					<a data-id="{{ $materiel->id }}" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-pen-to-square"></i> Supprimer </a>
					
	                </td>
	              </tr>
					@endif
	              
	              @endforeach
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

@endsection


@section('script')

<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("{{ route('admin.delete-materiel', ['id' => 'dataId']) }}".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        buttons: [
                    {
						title:'Liste des Matériels',
                        extend: 'copy',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'csv',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'excel',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'pdf',
						text: 'PDF',
                        exportOptions: {
							modifier: {
                            page: 'current'
                        },
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title: '<h2 style="text-align: center;">Liste des Matériels</h2>', // Title centered
						extend: 'print',
						text: 'Imprimer',
						exportOptions: {
							columns: [0, 2, 3, 4, 5]
						},
						customize: function (win) {
							$(win.document.body)
								.css('font-size', '10pt') // Optional: Adjust font size
								.prepend(
									'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
								);

							// Style the title
							$(win.document.body).find('h1')
								.css('text-align', 'center') // Ensure the title is centered
								.css('margin-bottom', '20px'); // Optional: Add spacing below the title
								
								
        					// Style the table explicitly
        					$(win.document.body).find('table').addClass('table table-bordered table-striped');
						}
					},

                    'colvis'
                ]
    });
</script>



@endsection