@extends('couvreur.layout')
@section('title') Modifier Profile @endsection
@section('content')

<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
            <h3>Modifier Profile</h3>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('couvreur.dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Modifier Profile
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>




<div class="row">
    
<div class="col-md-12">
    <div class="card">
                                
                                
                                <div class="card-content">
                                    <div class="card-body">
									<form method="post" action="{{ route('couvreur.update-profile') }}" enctype="multipart/form-data" >
                                        @csrf
                                            <div class="form-body">
												
												<div class="row mb-2">

                                                    <div class="col-md-3">
                                                        <label class="jblack-text-color"><strong>Password</strong></label>
                                                    </div>
                                                    <div class="col-md-9" width="100%">
                                                        <div class="form-group has-icon-left">
                                                            <div class="position-relative">
                                                                <input type="password" class="form-control" 
                                                                    placeholder="Entrez votre nouveau mot de passe ou laissez vide pour ne pas modifier"
                                                                    name="password" id="password" value="{{ $user->password ?? '' }}">
                                                                <div class="form-control-icon">
                                                                    <i class="bi bi-lock"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

												</div>
												
												<div class="row mb-2">
                                                    
                                                    <div class="col-12 d-flex justify-content-end">
                                                        <button type="submit" class="btn btn-block btn-xl btn-primary font-bold m-3">Mettre a jour Profile</button>
                                                        <button type="reset" class="btn btn-block btn-xl btn-light-primary font-bold m-3">Reset</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                
                                
                            </div>
                        </div>
                        
    </div>
    </div>
</div>

@endsection
@section('script')


<script>
    $(document).ready(function() {
    $('button[type="reset"]').click(function(event) {
        event.preventDefault(); // Prevent the default reset behavior

        // Clear all input fields
        $('input[type="text"], input[type="number"],input[type="email"],input[type="int"],input[type="password"],input[type="phone"], textarea').val('');

        // Reset file input
        $('input[type="file"]').val('');

        // Reset select dropdowns to the first option
        $('select').prop('selectedIndex', 0);
        
        // Reset any custom file input preview or other custom states (if applicable)
        $('.image-preview-filepond').filepond('clear');
    });
});
</script>
@endsection