<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="author" content="ZYDEV">
  
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Renov'Immo | Solution de Gestion</title>
  <!-- plugins:css -->
  <link rel="stylesheet" href="{{ asset('assets/vendors/feather/feather.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/vendors/ti-icons/css/themify-icons.css') }}">
  <link rel="stylesheet" href="{{ asset('assets/vendors/css/vendor.bundle.base.css') }}">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <!-- End plugin css for this page -->
  <!-- inject:css -->
  <link rel="stylesheet" href="{{ asset('assets/css/vertical-layout-light/style.css') }}">
  <!-- endinject -->
  <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}" />
  <link rel="stylesheet" href="{{ asset('assets/plugins/toastify/toastify.css') }}">
  <link href="https://unpkg.com/@tabler/icons-webfont@latest/tabler-icons.min.css" rel="stylesheet">
    <!-- <link rel="stylesheet" href="{{ asset('assets/plugins/toastr/toatr.css') }}"> -->
    
</head>
<body>
    @if (session()->has('error')) 
      <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            Toastify({
                text: "{{ Session::get('error') }}",
                duration: 3000,
                close: true,
                gravity: "top",
                position: "right",
                backgroundColor: "#F44336", // Background color for error
                stopOnFocus: true
            }).showToast();
        });
      </script>
    @endif
    @if (session()->has('success'))
      <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            Toastify({
                text: "{{ Session::get('success') }}",
                duration: 3000, // Duration in milliseconds
                close: true, // Show the close icon
                gravity: "top", // Position vertically: top or bottom
                position: "right", // Position horizontally: left, center, or right
                backgroundColor: "#4CAF50", // Background color for success
                stopOnFocus: true // Prevents dismissing of toast on hover
            }).showToast();
        });
      </script>
    @endif
    @if ($errors->any())
      @foreach ($errors->all() as $error)
        <script type="text/javascript">
          document.addEventListener('DOMContentLoaded', function () {
              Toastify({
                  text: "{{ $error }}",
                  duration: 3000,
                  close: true,
                  gravity: "top",
                  position: "right",
                  backgroundColor: "#F44336", // Background color for error
                  stopOnFocus: true
              }).showToast();
          });
        </script>
      @endforeach
    @endif

<div class="container-scroller">
    <div class="container-fluid page-body-wrapper full-page-wrapper">
        <div class="content-wrapper d-flex align-items-center auth px-0" style=" background-color: #02111e;">
            <div class="row w-100 mx-0">
                <div class="col-lg-4 mx-auto">
                    <div class="auth-form-light text-center py-5 px-4 px-sm-5">
                        <div class="brand-logo">
                            <img src="{{ asset('assets/images/RenovImmo-FOND-BLANC.jpg') }}" alt="logo">
                        </div>
                        <!-- <h4>Bonjour!, Commençons</h4> -->
                        <h6 class="font-weight-light">Se connecter à la Plateforme Renov'Immo.</h6>
                        <form class="pt-3" method="post" action="{{ route('employee.login') }}">
                        @csrf
                            <div class="form-group">
                                <label for="employee_id">Salarié</label>
                                <select class="form-control text-black" style="color:black;" name="employee_id" required>
                                    <option value="">Sélectionner un salarié</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}">{{ $employee->name }} {{ $employee->prenom }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" class="pass-input form-control form-control-lg" placeholder="Mot de Passe" required>
                            </div>
                            <div class="mt-3">
                                <button type="submit" class="btn btn-block btn-primary btn-lg font-weight-medium auth-form-btn">Se Connecter</button>
                            </div>
                                        
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- content-wrapper ends -->
    </div>
    <!-- page-body-wrapper ends -->
</div>





    <script src="{{ asset('assets/js/off-canvas.js') }}"></script>
    <script src="{{ asset('assets/js/hoverable-collapse.js') }}"></script>
    <script src="{{ asset('assets/js/template.js') }}"></script>
    <script src="{{ asset('assets/js/settings.js') }}"></script>
    <script src="{{ asset('assets/js/todolist.js') }}"></script>
    <script src="{{ asset('assets/plugins/toastify/toastify.js') }}"></script>
</body>
</html>