@extends('employee.layout')
@section('title') Demander des Matériels @endsection
@section('content')

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Demander des Matériels</h2>
        </div>
        <div class="col-4">
            
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Image</th>
                                <th>Référence</th>
                                <th>Matériel</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach($materiels as $materiel)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                @if($materiel->photo)
                                        @php $photos = json_decode($materiel->photo); @endphp
                                        @if(!empty($photos))
                                            @foreach($photos as $photo)
                                                @if(file_exists(public_path('uploads/' . $photo)))
                                                    <img src="{{ asset('uploads/' . $photo) }}" alt="Photo" class="rounded" height="50" width="50"/>
                                                    @break
                                                @else
                                                    <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                                    @break
                                                @endif
                                            @endforeach
                                        @else
                                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                        @endif
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                    @endif

                                    
                                </td>
                                <td class="font-weight-bold">{{ $materiel->reference ?? 'Aucun' }}</td>
                                <td class="font-weight-bold">{{ $materiel->materiel }}</td>
                                
                                <td>
                                    <!-- <span class="badge bg-success text-white">{{ $materiel->status }}</span> -->

                                    @if($materiel->status == 'disponible')
                                        <span class="badge bg-success text-white">Disponible</span>
                                    @else
                                        <span class="badge bg-warning text-white">Non Disponible</span>
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-primary btn-sm request-btn" 
                                            data-id="{{ $materiel->id }}" 
                                            data-name="{{ $materiel->materiel }}"
                                            data-reference="{{ $materiel->reference }}">
                                            Emprunter
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Request Modal -->
<div class="modal fade" id="requestModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('employee.request-materiel') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Demander un Matériel</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="materiel_id" id="materiel_id">
                    <div class="mb-3">
                        <label>Matériel:</label>
                        <input type="text" class="form-control" id="materiel_name" readonly>
                    </div>
                    <div class="mb-3">
                        <label>Référence:</label>
                        <input type="text" class="form-control" id="materiel_reference" readonly>
                    </div>
                    <div class="mb-3">
                        <label>Date Nécessaire (Optionnel):</label>
                        <input type="date" name="date_needed" class="form-control" min="{{ date('Y-m-d') }}">
                    </div>
                    <div class="mb-3">
                        <label>Raison (Optionnel):</label>
                        <textarea name="reason" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Emprunter Matériel</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$('.request-btn').click(function(){
    var materielId = $(this).data('id');
    var materielName = $(this).data('name');
    var reference = $(this).data('reference');
    
    $('#materiel_id').val(materielId);
    $('#materiel_name').val(materielName);
    $('#materiel_reference').val(reference || 'Aucun');
    
    $('#requestModal').modal('show');
});


$('#table1').DataTable({
        dom: 'Bfrtip',
        buttons: [
                    {
						title:'Liste des Matériels',
                        extend: 'copy',
                        exportOptions: {
                            columns: [0, 2, 3, 4]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'csv',
                        exportOptions: {
                            columns: [0, 2, 3, 4]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'excel',
                        exportOptions: {
                            columns: [0, 2, 3, 4]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'pdf',
						text: 'PDF',
                        exportOptions: {
							modifier: {
                            page: 'current'
                        },
                            columns: [0, 2, 3, 4]
                        }
                    },
                    {
						title: '<h2 style="text-align: center;">Liste des Matériels</h2>', // Title centered
						extend: 'print',
						text: 'Imprimer',
						exportOptions: {
							columns: [0, 2, 3, 4]
						},
						customize: function (win) {
							$(win.document.body)
								.css('font-size', '10pt') // Optional: Adjust font size
								.prepend(
									'<div style="text-align: center;"><img src="{{ asset('assets/images/RenovImmo-long.png') }}" style="width: 80%; margin-bottom: 20px;" /></div>'
								);

							// Style the title
							$(win.document.body).find('h1')
								.css('text-align', 'center') // Ensure the title is centered
								.css('margin-bottom', '20px'); // Optional: Add spacing below the title
								
								
        					// Style the table explicitly
        					$(win.document.body).find('table').addClass('table table-bordered table-striped');
						}
					},

                    'colvis'
                ]
    });
</script>
@endsection