@extends('employee.layout')
@section('title') Mes Demandes de Matériels @endsection
@section('content')

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Mes Demandes de Matériels</h2>
        </div>
        <div class="col-4">
            <div class="justify-content-end d-flex">
                <a href="{{ route('employee.materiels') }}" class="btn btn-primary mr-2">
                    <i class="fa fa-plus"></i> Nouvelle Demande
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Image</th>
                                <th>Matériel</th>
                                <th>Référence</th>
                                <th>Date Nécessaire</th>
                                <th>Raison</th>
                                <th>Status</th>
                                <th>Date Demande</th>
                                <th>Notes Admin</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            @foreach($requests as $request)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if($request->materiel->photo)
                                        @php $photos = json_decode($request->materiel->photo); @endphp
                                        @if(!empty($photos))
                                            <img src="{{ asset('uploads/' . $photos[0]) }}" alt="Photo" class="rounded" height="50" width="50"/>
                                        @else
                                            <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                        @endif
                                    @else
                                        <img src="{{ asset('assets/images/no_image.png') }}" alt="No Image" class="rounded" height="50" width="50"/>
                                    @endif
                                </td>
                                <td class="font-weight-bold">{{ $request->materiel->materiel }}</td>
                                <td class="font-weight-bold">{{ $request->materiel->reference ?? 'Aucun' }}</td>
                                <td>
                                    @if($request->date_needed)
                                        {{ \Carbon\Carbon::parse($request->date_needed)->format('d/m/Y') }}
                                    @else
                                        <span class="text-muted">Non spécifié</span>
                                    @endif
                                </td>
                                <td>{{ $request->reason ?? '-' }}</td>
                                <td>
                                    @if($request->status == 'pending')
                                        <span class="badge bg-warning text-white">En Attente</span>
                                    @elseif($request->status == 'approved')
                                        <span class="badge bg-success text-white">Approuvé</span>
                                    @else
                                        <span class="badge bg-danger text-white">Rejeté</span>
                                    @endif
                                </td>
                                <td>{{ $request->created_at->format('d/m/Y H:i') }}</td>
                                <td>
                                    @if($request->admin_notes)
                                        <span class="text-muted">{{ $request->admin_notes }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script>
$('#table1').DataTable({
    order: [[7, 'desc']], // Sort by date column (index 7) in descending order
    language: {
        url: '{{ asset("assets/fr-FR.json") }}'
    }
});
</script>
@endsection