@extends('manager.layout')
@section('title') Dashbaord @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card shadow mb-4">
	    	<div class="card-body">
	          <div class="card-title">
	            <strong>Order Report</strong>
	            <a class="float-right small text-muted" href="{{ route('manager.order-report') }}">View all</a>
	          </div>
	          <div class="row">
	            <div class="col-md-12">
	              <div id="chart-box">
	                <canvas id="myChart"  height="150"></canvas>
	              </div>
	            </div>
	          </div> <!-- .row -->
	    	</div> <!-- .card-body -->
	    </div>
	</div>
</div>
@endsection
@section('script')
<script type="text/javascript">
	var employeeData = <?= $chartData; ?>;
	var keys = Object.keys(employeeData);

    var employees = Object.keys(employeeData);
    var dates = Object.keys(employeeData[keys[0]]); 
    var statuses = ['Pending','Confirmed','Picked Up','Returned','Delivered' ];

    // Function to generate random colors
    function getRandomColor() {
        var letters = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
    
    var datasets = employees.flatMap((employee, employeeIndex) =>
        statuses.map((status, statusIndex) => ({
            label: employee + ' - ' + status,
            data: dates.map(date => employeeData[employee][date][statusIndex]),
            backgroundColor: getRandomColor(),
            borderWidth: 1,
            stack: employee
        }))
    );

    // Chart configuration
    var config = {
        type: 'bar',
        data: {
            labels: dates,
            datasets: datasets
        },
        options: {
            responsive: true,
            title: {
                display: true,
                text: 'Employee Orders by Date and Status'
            },
            scales: {
                xAxes: [{
                    stacked: true,
                    scaleLabel: {
                        display: true,
                        labelString: 'Date'
                    }
                }],
                yAxes: [{
                    stacked: true,
                    scaleLabel: {
                        display: true,
                        labelString: 'Number of Orders'
                    }
                }]
            },
            tooltips: {
                mode: 'index',
                intersect: false
            }
        }
    };

    // Render the chart
    var ctx = document.getElementById('myChart').getContext('2d');
    new Chart(ctx, config);
</script>
@endsection