@extends('manager.layout')
@section('title') Edit Employee @endsection
@section('content')
<div class="row">
	<div class="col-md-12">
		<div class="card p-2">
			<center>
				<span class="text-primary" style="font-size:25px;"><i class="fa-solid fa-users-rays"></i>&nbsp;&nbsp;Edit Employee</span>
			</center>
		</div>
	</div>
</div>
<br><br>
<div class="row">
	<div class="col-md-4">
		<div class="card p-2">
			<div class="card-header">
				<strong class="card-title"><i class="fa-solid fa-pencil"></i> Edit Employee</strong>
			</div>
			<div class="card-body">
				<form method="post" action="{{ route('manager.update-employee') }}">
					@csrf
					<input type="hidden" name="employee" value="{{ $current_employee->id }}">
					<div class="form-group mb-3">
          	<label for="name">Full Name</label>
          	<input id="name" name="name" value="{{ $current_employee->name }}"  class="form-control" placeholder="Full Name" required>
          </div>
          <div class="form-group mb-3">
          	<label for="email">Email</label>
          	<input type="email" id="email" value="{{ $current_employee->email }}"  name="email" class="form-control" placeholder="Email" required>
          </div>
          <div class="form-group mb-3">
              <label for="phone">Phone Number</label>
              <input  id="phone" name="phone" value="{{ $current_employee->phone }}"  class="form-control" placeholder="Phone Number" required>
          </div>
          <div class="form-group mb-3">
              <label for="password">Password</label>
              <input type="password" id="password"  name="password" class="form-control" placeholder="Password">
          </div>
          <div class="form-group mb-3">
              <label for="orders_limit">Max Orders Per Day</label>
              <input id="orders_limit" name="orders_limit" class="form-control" placeholder="Order Limit Per Day" value="{{ $current_employee->orders_limit }}" required>
          </div>
          <button type="submit" class="btn btn-primary btn-block"><i class="fa-solid fa-floppy-disk"></i> Update Employee</button>
				</form>
			</div>
		</div>
		<br><br>
	</div>
	<div class="col-md-8">
		<div class="card shadow">
	        <div class="card-body">
	          <!-- table -->
	          <table class="table datatables" id="dataTable">
	            <thead>
	              <tr>
	                <th>#</th>
	                <th>Name</th>
	                <th>Phone</th>
	                <th>Email</th>
	                <th>Daily Order Limit</th>
	                <th>Action</th>
	              </tr>
	            </thead>
	            <tbody>
	            	<?php $i= 1; ?>
	              @foreach($employees as $employee)
	              <tr>
	                <td>{{ $i++ }}</td>
	                <td>{{ $employee->name }}</td>
	                <td>{{ $employee->phone }}</td>
	                <td>{{ $employee->email }}</td>
	                <td>{{ $employee->orders_limit }}</td>
	                <td><button class="btn btn-sm dropdown-toggle more-horizontal" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
	                    <span class="text-muted sr-only">Action</span>
	                  </button>
	                  <div class="dropdown-menu dropdown-menu-right">
	                    <a class="dropdown-item" href='{{ route("manager.edit-employee",$employee->id) }}'>Edit</a>
	                    <a class="dropdown-item" href='{{ route("manager.employee-orders",$employee->id) }}'>Employee Orders</a>
	                    <a class="dropdown-item" href='{{ route("manager.employee-report",$employee->id) }}'>Employee Report</a>
	                    <a class="dropdown-item" href='{{ route("manager.add-message",$employee->id) }}'>Message Employee</a>
	                  </div>
	                </td>
	              </tr>
	              @endforeach
	            </tbody>
	          </table>
	        </div>
	    </div>
	</div>
</div>
<script>
  $('#dataTable').DataTable(
  {
    autoWidth: true,
    "lengthMenu": [
      [16, 32, 64, -1],
      [16, 32, 64, "All"]
    ]
  });
</script>

@endsection