<?php $__env->startSection('title'); ?> Modifier Materiel <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<style>

.img-materiel {
    width: auto;
}
</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Modifier Materiel</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/materiels">Materiels</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Modifier Materiel
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="<?php echo e(route('admin.update-materiel')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($materiel->id); ?>">
        
        <div class="form-group">
            <label for="reference">Référence</label>
            <input name="reference" id="reference" value="<?php echo e($materiel->reference); ?>" type="text" class="form-control" maxlength="11" required>
        </div>
        
        <div class="form-group">
            <label for="materiel">Materiel</label>
            <input name="materiel" id="materiel" value="<?php echo e($materiel->materiel); ?>" type="text" class="form-control" required>
        </div>

        <div class="form-group">
        <label for="prix_achat">Prix D'achat</label>
            <div class="input-group">
                <div class="input-group-prepend">
                <span class="input-group-text bg-primary text-white">€</span>
                </div>
                <input name="prix_achat" id="prix_achat" type="number" step="0.01" min="0.01" class="form-control" value="<?php echo e($materiel->prix_achat); ?>" aria-label="Prix d'achat en EUR">
                
            </div>
        </div>

        <div class="form-group">
                <label for="photos">Images</label>
                <div class="d-flex flex-wrap mb-2">
                    
						<?php if($materiel->photo): ?>
							<?php $photos = json_decode($materiel->photo); ?>
                            <?php if(!empty($photos)): ?>

                                <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php if( file_exists(public_path('uploads/' . $photo)) ): ?>
                                        <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
						<?php else: ?>
							<img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="rounded" height="200" width="auto"/>
						<?php endif; ?>
                </div>
            
            <input type="file" name="photo[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>


            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-materiel rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/edit-materiel.blade.php ENDPATH**/ ?>