<?php $__env->startSection('title'); ?> Gestion des Administrateurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="intro-y  mb-3 flex items-center">
	<div class="row">

		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Administrateurs</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="<?php echo e(route('admin.add-admin')); ?>" class="btn btn-primary mr-2">Ajouter Administrateur</a>
			</div>			 
		</div>

	</div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Email</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	              <tr>
	                <td><?php echo e($i++); ?></td>
	                <td class="font-weight-bold"><?php echo e($admin->name ?? ''); ?></td>
	                <td class="font-weight-bold"><?php echo e($admin->prenom ?? ''); ?></td>
	                <td class="font-weight-medium"><div class="badge badge-success"><?php echo e($admin->email ?? ''); ?></div></td>

	                <td>
					<a href='<?php echo e(route("admin.edit-admin",$admin->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="<?php echo e($admin->id); ?>" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-pen-to-square"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("<?php echo e(route('admin.delete-admin', ['id' => 'dataId'])); ?>".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>




<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        buttons: [
            {
				title:'Affectation des Matériels',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Affectation des Matériels',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title: '<h2 style="text-align: center;">Affectation des Matériels</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 1, 2, 3, 4]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 100%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
				}
			},

            'colvis'
        ]
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/admins.blade.php ENDPATH**/ ?>