<?php $__env->startSection('title'); ?> Gestion Métiers <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<div class="intro-y  mb-3 flex items-center">
    
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		<h2 class="mr-auto text-lg font-medium">Gestion des Métiers</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				
				<a href="<?php echo e(route('admin.add-metier')); ?>" class="btn btn-primary mr-2">Ajouter Métier</a>
      
			</div>			 
		</div>

	</div>

</div>


<br>



<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Date</th>
                    <th>Nom Métier</th>
                    <th>Salariés</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                <?php $__currentLoopData = $metiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	              <tr>
	                <td><?php echo e($i++); ?></td>
	                <td class="font-weight-medium"><div class="badge badge-success"><?php echo e($metier->date); ?></div></td>
	                <td class="font-weight-bold"><?php echo e($metier->nom); ?></td>
	                <td class="font-weight-medium">
					
						<?php if(!empty($metier->employees)): ?>
						<?php
						$employees = json_decode($metier->employees);
						foreach($employees as $empl){
							$employee = \App\Models\User::find($empl);
							if($employee)
							echo "<span class='badge badge-primary text-white mr-1'>".$employee->name."</span>, ";
						}
						
						?>
						<?php endif; ?>
					</td>
	                
	                <td>
					<a href='<?php echo e(route("admin.edit-metier",$metier->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="<?php echo e($metier->id); ?>" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-trash"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>




<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script type="text/javascript">
	$('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`<?php echo e(route("admin.delete-metier", [":dataId"])); ?>`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>


<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        buttons: [
            {
				title:'Liste des Métiers',
                extend: 'copy',
                exportOptions: {
                    columns: [0,  1, 2, 3]
                }
            },
            {
				title:'Liste des Métiers',
                extend: 'csv',
                exportOptions: {
                    columns: [0,  1, 2, 3]
                }
            },
            {
				title:'Liste des Métiers',
                extend: 'excel',
                exportOptions: {
                    columns: [0,  1, 2, 3]
                }
            },
            {
				title:'Liste des Métiers',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0,  1, 2, 3]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Métiers</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0,  1, 2, 3]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/metiers.blade.php ENDPATH**/ ?>