<?php $__env->startSection('title'); ?> Gestion des Matériels <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="intro-y  mb-3 flex items-center">
	<div class="row">

		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Matériels</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="<?php echo e(route('admin.add-materiel')); ?>" class="btn btn-primary mr-2">Ajouter Matériel</a>
				<a href="<?php echo e(route('admin.affectation-materiel-salarie')); ?>" class="btn btn-primary mr-2">Affectation Salarié</a>
			</div>			 
		</div>

	</div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Référence</th>
                    <th>Matériel</th>
                    <th>Prix d'achat</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                <?php $__currentLoopData = $materiels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $materiel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<?php if($materiel->status == 'disponible'): ?>
				<tr>
	                <td><?php echo e($i++); ?></td>
                    <td>
                        <?php if($materiel->photo): ?>
                        <?php $photos = json_decode($materiel->photo); ?>
                            <?php if(!empty($photos)): ?>
                                <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(file_exists(public_path('uploads/' . $photo))): ?>
                                        <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="rounded" height="50" width="50"/>
                                        <?php break; ?>
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                        <?php break; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                            <?php endif; ?>
                        <?php else: ?>
                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                        <?php endif; ?>
                    </td>
					
                    <td class="font-weight-bold">
					<?php if($materiel->reference): ?>
						<?php echo e($materiel->reference ?? ''); ?>

						<?php else: ?>
						<span class="text-muted">Aucun</span>
						<?php endif; ?>
					</td>
	                <td class="font-weight-bold"><?php echo e($materiel->materiel ?? ''); ?></td>
	                <td class="font-weight-bold">€ <?php echo e($materiel->prix_achat ?? ''); ?></td>
	                
	                <td class="font-weight-bold">
						<?php if($materiel->status == 'disponible'): ?>
						<span class="badge bg-success text-white"><?php echo e($materiel->status ?? ''); ?></span>
						<?php else: ?>
						<span class="badge bg-danger text-white"><?php echo e($materiel->status ?? ''); ?></span>
						<?php endif; ?>
					</td>
	                <td>
    					<a href='<?php echo e(route("admin.edit-materiel",$materiel->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
    					<a data-id="<?php echo e($materiel->id); ?>" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-pen-to-square"></i> Supprimer </a>
					
	                </td>
	              </tr>
					<?php endif; ?>
	              
	              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("<?php echo e(route('admin.delete-materiel', ['id' => 'dataId'])); ?>".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        buttons: [
                    {
						title:'Liste des Matériels',
                        extend: 'copy',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'csv',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'excel',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title:'Liste des Matériels',
                        extend: 'pdf',
						text: 'PDF',
                        exportOptions: {
							modifier: {
                            page: 'current'
                        },
                            columns: [0, 2, 3, 4, 5]
                        }
                    },
                    {
						title: '<h2 style="text-align: center;">Liste des Matériels</h2>', // Title centered
						extend: 'print',
						text: 'Imprimer',
						exportOptions: {
							columns: [0, 2, 3, 4, 5]
						},
						customize: function (win) {
							$(win.document.body)
								.css('font-size', '10pt') // Optional: Adjust font size
								.prepend(
									'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
								);

							// Style the title
							$(win.document.body).find('h1')
								.css('text-align', 'center') // Ensure the title is centered
								.css('margin-bottom', '20px'); // Optional: Add spacing below the title
								
								
        					// Style the table explicitly
        					$(win.document.body).find('table').addClass('table table-bordered table-striped');
						}
					},

                    'colvis'
                ]
    });
</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/materiels.blade.php ENDPATH**/ ?>