<?php $__env->startSection('title'); ?> Planning Chantiers <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-12 mb-4">
        
        <div class="btn-group mr-3" role="group" aria-label="Vue">
            
            <div class="btn-group mr-3" role="group" aria-label="Vue">
            
                <a href="<?php echo e(route('admin.timeline-employees')); ?>" class="btn btn-outline-primary"><i class="fas fa-hard-hat"></i> Vue Par Salariés</a>
                <a href="<?php echo e(route('admin.planning')); ?>" class="btn btn-primary"><i class="fa-regular fa-calendar"></i> Calendrier Chantiers</a>
                <a href="<?php echo e(route('admin.timeline-chantier')); ?>" class="btn btn-outline-primary"><i class="fa-solid fa-timeline"></i> Chronologie des Chantiers</a>
            </div>
        </div>
        <button id="printBtn" class="btn btn-secondary text-white ml-2" style="background-color: #01152b;">
            <i class="fas fa-print"></i> Imprimer
        </button>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div id='calendar'></div>
            </div>
        </div>
    </div>
</div>

<!-- New Chantier Modal -->
<div class="modal fade" id="newChantierModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Nouveau Chantier</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="newChantierForm">
                    <div class="form-group">
                        <label>Nom du chantier</label>
                        <input type="text" class="form-control" id="nom" name="nom" required>
                    </div>
                    <div class="form-group">
                        <label>Adresse</label>
                        <input type="text" class="form-control" id="adresse" name="adresse" required>
                    </div>
                    <div class="form-group">
                        <label>Date de début</label>
                        <input type="date" class="form-control" id="date_de_debut" name="date_de_debut" required>
                    </div>
                    <div class="form-group">
                        <label>Date de fin</label>
                        <input type="date" class="form-control" id="date_de_fin" name="date_de_fin" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                <button type="button" class="btn btn-primary" id="saveNewChantier">Enregistrer</button>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="myModal">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"> Ajouter un rendez-vous</h4>
        <button type="button" class="btn btn-danger" data-dismiss="modal">&times;</button>
      </div>


    </div>
  </div>
</div>

<!-- Modal Détails Chantier -->
<div class="modal fade" id="chantierModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Détails du Chantier</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Nom du chantier:</label>
                            <input type="text" class="form-control" id="chantier_nom" readonly>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Adresse:</label>
                            <input type="text" class="form-control" id="chantier_adresse" readonly>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Date de début:</label>
                            <input type="text" class="form-control" id="chantier_date_debut" readonly>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Date de fin:</label>
                            <input type="text" class="form-control" id="chantier_date_fin" readonly>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label>Nombre de jours:</label>
                    <input type="number" class="form-control" id="nbjours" readonly>
                </div>
                <div class="form-group">
                    <label>Tâches:</label>
                    <div id="tachesList" class="list-group">
                        <!-- Tâches will be inserted here -->
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" id="editChantierBtn" class="btn btn-primary">Modifier</a>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

<script>
var calendar;

function initializeCalendar() {
    var calendarEl = document.getElementById('calendar');
    calendar = new FullCalendar.Calendar(calendarEl, {
        themeSystem: 'bootstrap',
        locale: 'fr',
        initialView: 'dayGridMonth',
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,dayGridDay,listMonth'
        },
        
        weekNumbers: false,
        events: <?php echo json_encode($events, 15, 512) ?>,
        editable: false,
        eventStartEditable: false,     // prevents dragging
        eventDurationEditable: false,  // prevents resizing
        
        selectable: true,
        hiddenDays: [0, 6],
        select: function(info) {
            // Clear form fields
            $('#newChantierModal #nom').val('');
            $('#newChantierModal #adresse').val('');
            $('#newChantierModal #date_de_debut').val(info.startStr);
            $('#newChantierModal #date_de_fin').val(info.endStr);
            
            // Show modal
            $('#newChantierModal').modal('show');
        },
        eventDisplay: 'block',
        displayEventEnd: true, // Show end date
        eventDidMount: function(info) {
            // Generate a unique color based on chantier ID
            const hue = (parseInt(info.event.id) * 137.508) % 360;
            info.el.style.backgroundColor = `hsl(${hue}, 70%, 50%)`;
        },
        eventClick: function(info) {
            var chantierId = info.event.id;
            $.ajax({
                url: '<?php echo e(url("/admin/get-chantier-details")); ?>/' + chantierId,
                method: 'GET',
                success: function(chantier) {
                    $('#chantier_nom').val(chantier.nom);
                    $('#chantier_adresse').val(chantier.adresse);
                    $('#chantier_date_debut').val(chantier.date_de_debut);
                    $('#chantier_date_fin').val(chantier.date_de_fin);
                    $('#nbjours').val(chantier.nbjours);
                    
                    // Clear and populate tasks
                    var tachesList = $('#tachesList');
                    tachesList.empty();
                    
                    if (chantier.taches && chantier.taches.length > 0) {
                        chantier.taches.forEach(function(tache) {
                            let employeesHtml = '';
                            if (tache.employees) {
                                const employees = typeof tache.employees === 'string' ? JSON.parse(tache.employees) : tache.employees;
                                employeesHtml = '<div class="mt-2"><strong>Salariés:</strong><br>';
                                employees.forEach(function(empId) {
                                    const employee = chantier.all_employees.find(e => e.id === parseInt(empId));
                                    if (employee) {
                                        employeesHtml += `<span class="badge badge-primary mr-1">${employee.prenom ?? ''} ${employee.name ?? ''}</span>`;
                                    }
                                });
                                employeesHtml += '</div>';
                            }

                            let photoHtml = '';
                            if (tache.photo) {
                                const photos = typeof tache.photo === 'string' ? JSON.parse(tache.photo) : tache.photo;
                                photoHtml = '<div class="mt-2 task-photos">';
                                photos.forEach(function(photo) {
                                    photoHtml += `<img src="/uploads/${photo}" class="img-thumbnail mr-2" style="height: 100px;">`;
                                });
                                photoHtml += '</div>';
                            }

                            tachesList.append(`
                                <div class="list-group-item">
                                    <h6 class="mb-1">${tache.nom ?? ''}</h6>
                                    <div class="task-details">
                                        <div><strong>Date début:</strong> ${tache.date_debut ?? ''}</div>
                                        <div><strong>Date fin:</strong> ${tache.date_fin ?? ''}</div>
                                        <div><strong>Jours de travail:</strong> ${tache.nb_jours ?? ''}</div>
                                        ${employeesHtml}
                                        ${photoHtml}
                                    </div>
                                </div>
                            `);
                        });
                    } else {
                        tachesList.append('<div class="list-group-item">Aucune tâche</div>');
                    }
                    
                    $('#editChantierBtn').attr('href', '/admin/edit-chantier/' + chantier.id);
                    $('#chantierModal').modal('show');
                },
                error: function() {
                    toastr.error('Erreur lors du chargement des détails du chantier');
                }
            });
        }
    });
    calendar.render();
    
    return calendar;
}

$(document).ready(function() {
    calendar = initializeCalendar();

    // Print functionality
    $('#printBtn').click(function() {
        var printWindow = window.open('', '_blank');
        var calendarEl = document.querySelector('.fc');
        
        if (!calendarEl) {
            alert('Erreur: Calendrier non trouvé');
            return;
        }

        var printContent = `
            <!DOCTYPE html>
            <html>
            <head>
                <title>Planning des Chantiers</title>
                <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet" />
                <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
                <style>
                    @media  print {
                        @page  {
                            size: landscape;
                            margin: 1cm;
                        }
                        body {
                            margin: 0;
                            padding: 15px;
                        }
                        .fc-header-toolbar {
                            display: none !important;
                        }
                        .print-header {
                            margin-bottom: 20px;
                        }
                        .fc-view {
                            background-color: white !important;
                        }
                        .fc td, .fc th {
                            border: 1px solid #ddd !important;
                        }
                    }
                    .print-header {
                        text-align: center;
                        padding: 20px;
                    }
                    .fc-event {
                        page-break-inside: avoid !important;
                    }
                    .fc-event-title {
                        white-space: normal !important;
                    }
                </style>
            </head>
            <body>
                <div class="print-header">
                    <h2>Planning des Chantiers</h2>
                    <p>Date d'impression: ${new Date().toLocaleDateString('fr-FR')}</p>
                </div>
                ${calendarEl.outerHTML}
                <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"><\/script>
                <script>
                    window.onload = function() {
                        setTimeout(function() {
                            window.print();
                            window.close();
                        }, 500);
                    }
                <\/script>
            </body>
            </html>
        `;
        
        printWindow.document.write(printContent);
        printWindow.document.close();
    });
});

// Select the button element by its ID
var button = document.getElementById("saveNewChantier");

// Add an onclick attribute to the button
button.setAttribute("onclick", "createChantier()");

// Define the function to be called when the button is clicked
function createChantier() {
    window.nom2 = $('#newChantierModal #nom').val();
    window.adresse2 = $('#newChantierModal #adresse').val();
    window.date_de_debut2 = $('#newChantierModal #date_de_debut').val();
    window.date_de_fin2 = $('#newChantierModal #date_de_fin').val();

    // Perform AJAX request to update appointment
    $.ajax({
        url:'<?php echo e(route("admin.store-chantier-from-calendar")); ?>',
        type: 'post',
        data: {
            '_token':'<?php echo e(csrf_token()); ?>',
            'nom': window.nom2,
            'adresse': window.adresse2,
            'date_de_debut': window.date_de_debut2,
            'date_de_fin': window.date_de_fin2
        },
        success: function(response) {
            // Handle success response
            console.log('Chantier Added successfully.');
            // Close modal
            $('#newChantierModal').modal('hide');
            // Refresh calendar or update events dynamically
            location.reload();
        },
        error: function(xhr, status, error) {
            // Handle error response
            console.error('Error creating chantier:', error);
        }
    });

}


</script>


<?php $__env->stopSection(); ?>

<style>
.task-details {
    font-size: 0.9em;
    margin-top: 10px;
}

.task-photos {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin-top: 10px;
}

.task-photos img {
    object-fit: cover;
    border-radius: 4px;
}
</style>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/planning.blade.php ENDPATH**/ ?>