<?php $__env->startSection('title'); ?> Comptabilité <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-md-12 grid-margin">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">Statistiques de Travail des Employés</h4>

                <!-- Date Range Filter Form -->
                <form method="GET" class="mb-4">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="start_date">Date de début</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" 
                                       value="<?php echo e($start_date); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="end_date">Date de fin</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" 
                                       value="<?php echo e($end_date); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <button type="submit" class="btn btn-primary d-block">Filtrer</button>
                            </div>
                        </div>
                    </div>
                </form>

                <!-- Statistics Summary -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-striped table-borderless datatables" id="table1">
                                <thead>
                                    <tr>
                                        <th>Employé</th>
                                        <th>Jours de Travail Total</th>
                                        <th>Jours d'Absence</th>
                                        <th>Jours Réellement Travaillés</th>
                                        <th>Taux de Présence</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $employeeStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($stat['name']); ?></td>
                                        <td><?php echo e($stat['total_work_days']); ?></td>
                                        <td><?php echo e($stat['total_absence_days']); ?></td>
                                        <td><?php echo e($stat['real_worked_days']); ?></td>
                                        <td>
                                            <?php if($stat['total_work_days'] > 0): ?>
                                                <?php echo e(round(($stat['real_worked_days'] / $stat['total_work_days']) * 100, 1)); ?>%
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Statistics Charts -->
                <div class="row">
                    <!-- Work Days Distribution Chart -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Distribution des Jours de Travail</h4>
                                <canvas id="workDaysChart"></canvas>
                            </div>
                        </div>
                    </div>

                    <!-- Presence Rate Chart -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="card-title">Taux de Présence par Employé</h4>
                                <canvas id="presenceRateChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Prepare data for charts
    const employeeStats = <?php echo json_encode($employeeStats, 15, 512) ?>;
    const labels = employeeStats.map(stat => stat.name);
    
    // Work Days Distribution Chart
    new Chart(document.getElementById('workDaysChart'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [
                {
                    label: 'Jours de Travail Total',
                    data: employeeStats.map(stat => stat.total_work_days),
                    backgroundColor: 'rgba(54, 162, 235, 0.5)',
                },
                {
                    label: 'Jours d\'Absence',
                    data: employeeStats.map(stat => stat.total_absence_days),
                    backgroundColor: 'rgba(255, 99, 132, 0.5)',
                },
                {
                    label: 'Jours Réellement Travaillés',
                    data: employeeStats.map(stat => stat.real_worked_days),
                    backgroundColor: 'rgba(75, 192, 192, 0.5)',
                }
            ]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Nombre de Jours'
                    }
                }
            }
        }
    });

    // Presence Rate Chart
    new Chart(document.getElementById('presenceRateChart'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Taux de Présence (%)',
                data: employeeStats.map(stat => 
                    stat.total_work_days > 0 
                        ? (stat.real_worked_days / stat.total_work_days * 100).toFixed(1) 
                        : 0
                ),
                backgroundColor: 'rgba(153, 102, 255, 0.5)',
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    max: 100,
                    title: {
                        display: true,
                        text: 'Taux de Présence (%)'
                    }
                }
            }
        }
    });
});
</script>


<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        pageLength: 10, // Default number of rows per page
        lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
        buttons: [
            {
				title:'Statistiques de Travail des Employés: Entre <?php echo e($start_date); ?> et <?php echo e($end_date); ?>',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Statistiques de Travail des Employés: Entre <?php echo e($start_date); ?> et <?php echo e($end_date); ?>',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Statistiques de Travail des Employés: Entre <?php echo e($start_date); ?> et <?php echo e($end_date); ?>',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title:'Travail des Employés: Entre <?php echo e($start_date); ?> et <?php echo e($end_date); ?>',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
				title: '<h2 style="text-align: center;">Travail des Employés: Entre <?php echo e($start_date); ?> et <?php echo e($end_date); ?></h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 1, 2, 3, 4]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/comptabilite.blade.php ENDPATH**/ ?>