<?php $__env->startSection('title'); ?> Gestion Chantiers <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>




<div class="intro-y  mb-3 flex items-center">
    
	<div class="row">
		<div class="col-8 mb-4 mb-xl-0">
		<h2 class="mr-auto text-lg font-medium">Gestion des Chantiers</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				
				<a href="<?php echo e(route('admin.add-chantier')); ?>" class="btn btn-primary mr-2">Ajouter Chantier</a>
      
			</div>			 
		</div>

	</div>

</div>



     
<br>


        

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Nom</th>
                    <th>Adresse</th>
                    <th>Date de debut</th>
                    <th>Date de fin</th>
                    <th>Date fin Réelle</th>
                    <th>Enquête</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                <?php $__currentLoopData = $chantiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chantier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	              <tr>
                    <td class="text-center">
                        <?php if($chantier->photo && !empty($chantier->photo) && isset($chantier->photo[0]) && file_exists(public_path('uploads/' . $chantier->photo[0]))): ?>
                            <img src="<?php echo e(asset('uploads/' . $chantier->photo[0])); ?>" alt="Photo" class="rounded" height="200" width="200"/>
                        <?php else: ?>
                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="200" width="200"/>
                        <?php endif; ?>
                    </td>
	                <td class="font-weight-bold">
						<div class="mb-2"><?php echo e($chantier->nom ?? ''); ?></div>
						<?php
							$nb_taches = \App\Models\Tache::where('chantier_id',$chantier->id)->count();;
						?>
						<div class="badge badge-warning text-white"><i class="fa-solid fa-list-check"></i> <?php echo e($nb_taches ?? 0); ?> taches</div>
					</td>
	                <td class="font-weight-bold"><?php echo e($chantier->adresse ?? ''); ?></td>
	                <td class="font-weight-bold"><?php echo e($chantier->date_de_debut ?? ''); ?></td>
	                <td class="font-weight-bold"><?php echo e($chantier->date_de_fin ?? ''); ?></td>
	                <td class="font-weight-bold"><?php echo e($chantier->date_fin_reelle ?? 'N/A'); ?></td>
	                <td>
                        <?php if(empty($chantier->date_fin_reelle)): ?>
                            <span class="badge badge-warning text-white"><i class="fa-solid fa-exclamation-circle"></i> Pas de date</span>
                        <?php else: ?>
                            <?php
                                $difference = $chantier->nbjours - $chantier->nbjours_reelle;
                            ?>
                    
                            <?php if($difference < 0): ?>
                                
                                <span class="badge badge-danger text-white">
                                    <i class="fa-solid fa-circle-exclamation"></i> <?php echo e($difference ?? ''); ?> jours de retard
                                </span>
                            <?php else: ?>
                                <span class="badge badge-success text-white">
                                    <i class="fa-solid fa-circle-check"></i> <?php echo e($difference ?? ''); ?> jours en avance
                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>

	                
	                
	                <td>
					<a href='<?php echo e(route("admin.chantier-details", $chantier->id)); ?>' class="text-success mr-2"><i class="fa-solid fa-eye"></i> Details </a>
					<a href='<?php echo e(route("admin.edit-chantier", $chantier->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="<?php echo e($chantier->id); ?>" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-trash"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script type="text/javascript">
	$('.delete').click(function(){
	    
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Are you sure?",
		  text: "Once you confirm, this action cannot be undone!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Yes, delete!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    window.open(`<?php echo e(route("admin.delete-chantier", [":dataId"])); ?>`.replace(':dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        pageLength: 10, // Default number of rows per page
        lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
        buttons: [
            {
				title:'Liste des Chantiers',
                extend: 'copy',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'csv',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'excel',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title:'Liste des Chantiers',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [1, 2, 3, 4, 5, 6]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Chantiers</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [ 1, 2, 3, 4, 5, 6]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
					
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/chantiers.blade.php ENDPATH**/ ?>