<?php $__env->startSection('title'); ?> Demander des Éléments <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Demander des Éléments</h2>
        </div>
        
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Image</th>
                                <th>Élément</th>
                                <th>Stock Disponible</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td>
                                    <?php if($element->photo): ?>
                                        <?php $photos = json_decode($element->photo); ?>
                                        <?php if(!empty($photos)): ?>
                                            <img src="<?php echo e(asset('uploads/' . $photos[0])); ?>" alt="Photo" class="rounded" height="50" width="50"/>
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                    <?php endif; ?>
                                </td>
                                <td class="font-weight-bold"><?php echo e($element->element); ?></td>
                                <td class="font-weight-bold"><?php echo e($element->quantity); ?></td>
                                <td>
                                    <button class="btn btn-primary request-btn" 
                                            data-id="<?php echo e($element->id); ?>" 
                                            data-name="<?php echo e($element->element); ?>"
                                            data-stock="<?php echo e($element->quantity); ?>">
                                        Prendre Élement(s)
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Request Modal -->
<div class="modal fade" id="requestModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('employee.request-element')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Prendre un Élément</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="element_id" id="element_id">
                    <div class="mb-3">
                        <label>Élément:</label>
                        <input type="text" class="form-control" id="element_name" readonly>
                    </div>
                    <div class="mb-3">
                        <label>Stock Disponible:</label>
                        <input type="text" class="form-control" id="available_stock" readonly>
                    </div>
                    <div class="mb-3">
                        <label>Quantité Prise:</label>
                        <input type="number" name="quantity_requested" class="form-control" min="1" required>
                    </div>
                    <div class="mb-3">
                        <label>Raison (Optionnel):</label>
                        <textarea name="reason" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Prendre Élement(s)</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$('.request-btn').click(function(){
    var elementId = $(this).data('id');
    var elementName = $(this).data('name');
    var stock = $(this).data('stock');
    
    $('#element_id').val(elementId);
    $('#element_name').val(elementName);
    $('#available_stock').val(stock);
    
    $('#requestModal').modal('show');
});


$('#table1').DataTable({
		dom: 'Bfrtip',
		language: {
			url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
		},
		pageLength: -1, // Show all rows by default
		lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "Tous"] ], // "All" translated to "Tous"
		paging: false, // Disable pagination to show all rows
		info: false, // Hide info like "Showing 1 to 10 of 50 entries"
		searching: true, // Keep search functionality
		ordering: true, // Keep sorting functionality
        buttons: [
            {
				title:'Liste des Elements',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2, 3]
                }
            },
            {
				title:'Liste des Elements',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 2, 3]
                }
            },
            {
				title:'Liste des Elements',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 2, 3]
                }
            },
            {
				title:'Liste des Elements',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 2, 3]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Elements</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 2, 3]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 80%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '20px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('employee.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/employee/elements.blade.php ENDPATH**/ ?>