<?php $__env->startSection('title'); ?> Demandes de Matériels <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="intro-y mb-3 flex items-center">
    <div class="row">
        <div class="col-8 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Demandes de Matériels</h2>
        </div>
        <div class="col-4">
            <div class="justify-content-end d-flex">
                <a href="<?php echo e(route('admin.materiels')); ?>" class="btn btn-primary mr-2">
                    <i class="fa fa-arrow-left"></i> Retour aux Matériels
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-borderless datatables" id="table1">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Photo</th>
                                <th>Employé</th>
                                <th>Matériel</th>
                                <th>Référence</th>
                                <th>Date Nécessaire</th>
                                <th>Raison</th>
                                <th>Date Demande</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td>
                                    <?php if($request->materiel->photo): ?>
                                        <?php $photos = json_decode($request->materiel->photo); ?>
                                        <?php if(!empty($photos)): ?>
                                            <img src="<?php echo e(asset('uploads/' . $photos[0])); ?>" alt="Photo" class="rounded" height="50" width="50"/>
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded" height="50" width="50"/>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($request->employee->prenom); ?> <?php echo e($request->employee->name); ?></td>
                                <td><?php echo e($request->materiel->materiel); ?></td>
                                <td><?php echo e($request->materiel->reference ?? 'Aucun'); ?></td>
                                <td>
                                    <?php if($request->date_needed): ?>
                                        <?php echo e(\Carbon\Carbon::parse($request->date_needed)->format('d/m/Y')); ?>

                                    <?php else: ?>
                                        <span class="text-muted">Non spécifié</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($request->reason ?? '-'); ?></td>
                                <td><?php echo e($request->created_at->format('d/m/Y H:i')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.reject-materiel-request')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Rejeter la Demande</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="request_id" id="reject_request_id">
                    <div class="mb-3">
                        <label>Notes Admin (Optionnel):</label>
                        <textarea name="admin_notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-danger">Rejeter</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$('.approve-btn').click(function(e){
    e.preventDefault();
    var url = $(this).attr('href');
    
    Swal.fire({
        title: "Approuver la demande?",
        text: "Cette action affectera le matériel à l'employé et le marquera comme indisponible.",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Oui, approuver",
        cancelButtonText: "Annuler"
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url;
        }
    });
});

$('.reject-btn').click(function(){
    var requestId = $(this).data('id');
    $('#reject_request_id').val(requestId);
    $('#rejectModal').modal('show');
});

$('#table1').DataTable();
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/materiel-requests.blade.php ENDPATH**/ ?>