<?php $__env->startSection('title'); ?> Modifier Chantier <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<style>

.img-chantier {
    width: auto;
}
</style>



<div class="intro-y mb-3 flex items-center">
        
        <div class="row">
            <div class="col-4 mb-4 mb-xl-0">
            <h2 class="mr-auto text-lg font-medium">Modifier Tache</h2>
            </div>

            <div class="col-4">
                <div class="justify-content-end d-flex">
                    
        
                </div>			 
            </div>
            <div class="col-4 mb-6 mb-xl-0">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/admin/chantiers">Chantiers</a></li>
                    <li class="breadcrumb-item"><a href="/admin/chantier-details/<?php echo e($tache->chantier->id); ?>">Détail du Chantier</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Modifier Tache
                    </li>
                </ol>
            </nav>
        </div>


        </div>

    </div>


<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="<?php echo e(route('admin.update-tache-chantier')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($tache->id); ?>">
       
        <div class="form-group">
            <label for="nom">Tache</label>
            <input name="nom" id="nom" type="text" value="<?php echo e($tache->nom ?? ''); ?>" class="form-control" required>
        </div>
        
        <div class="form-group">
            <label for="description">Description</label>
            <textarea name="description" id="description" class="form-control" rows="3"><?php echo e($tache->description ?? ''); ?></textarea>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="date_debut">Date de début</label>
                    <input name="date_debut" id="date_debut" type="date" class="form-control" value="<?php echo e($tache->date_debut ?? ''); ?>" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="date_fin">Date de fin</label>
                    <input name="date_fin" id="date_fin" type="date" class="form-control" value="<?php echo e($tache->date_fin ?? ''); ?>" required>
                </div>
            </div>
        </div>
        
        
        <div class="form-group">
            <label for="status">Statut</label>
            <select id="status" name="status" class="form-control mb-3">
                <option value="pending" <?= ($tache->status == "pending")?'selected':''; ?>>En Attente</option>
                <option value="in_progress" <?= ($tache->status == "in_progress")?'selected':''; ?>>En Cours</option>
                <option value="completed" <?= ($tache->status == "completed")?'selected':''; ?>>Complété</option>
            </select>
        </div>


        <div class="form-group">
            <label for="salaries">Salariés</label>
            <br>
            <select id="employees" name="employees[]" class="js-example-basic-multiple form-control w-100" multiple="multiple">
                <?php
                    $selectedEmployees = is_array($tache->employees) ? $tache->employees : json_decode($tache->employees, true);
                ?>
                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($employee->id ?? ''); ?>" 
                        <?php echo e(in_array($employee->id, $selectedEmployees ?? []) ? 'selected' : ''); ?>>
                        <?php echo e($employee->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        


        <div class="form-group">
            <label for="photos">Photos</label>
            <div class="d-flex flex-wrap mb-2">
                <?php if($tache->photo): ?>
                    <?php
                        $photos = is_array($tache->photo) ? $tache->photo : json_decode($tache->photo, true);
                    ?>
                    <?php if(!empty($photos)): ?>
                        <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(file_exists(public_path('uploads/' . $photo))): ?>
                                <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="rounded" height="200" width="auto"/>
                    <?php endif; ?>
                <?php else: ?>
                    <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="rounded" height="200" width="auto"/>
                <?php endif; ?>
            </div>

            <input type="file" name="photos[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>



            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>

    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-chantier rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/edit-tache-chantier.blade.php ENDPATH**/ ?>