<?php $__env->startSection('title'); ?> Chronologie des Employés <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<style>
    /* Existing styles preserved */
    .tache-item {
        border: 1px solid #dee2e6;
        background: #f8f9fa;
        border-radius: 8px;
        margin-bottom: 15px;
        padding: 15px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        transition: all 0.3s ease;
    }

    .tache-item:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        border-color: #025182;
    }

    .tache-item .row {
        background: #f8f9fa;
        border-radius: 4px;
        padding: 10px;
        margin-bottom: 15px;
    }

    .tache-item .form-group {
        margin-bottom: 15px;
    }

    .tache-item label {
        font-weight: 500;
        color: #495057;
    }

    .remove-tache {
        background: #dc3545;
        border: none;
        padding: 6px 12px;
        border-radius: 4px;
        transition: all 0.2s ease;
    }

    .remove-tache:hover {
        background: #c82333;
        transform: translateY(-1px);
    }

    #addTacheBtn {
        background: #025182;
        color: white;
        border: none;
        padding: 8px 20px;
        border-radius: 4px;
        transition: all 0.2s ease;
    }

    #addTacheBtn:hover {
        background: #01406b;
        transform: translateY(-1px);
    }

    .select2-container--bootstrap4 .select2-selection {
        height: 40px !important;
        border-radius: 4px;
        border: 1px solid #ced4da;
    }

    .select2-container--bootstrap4 .select2-selection--multiple {
        min-height: 40px !important;
    }

    .select2-container--bootstrap4 .select2-selection__rendered {
        padding: 8px 12px;
    }

    .select2-container--bootstrap4 .select2-selection__choice {
        background-color: #025182;
        border: 1px solid #025182;
        color: white;
        border-radius: 20px;
        padding: 0 10px;
        margin: 4px;
    }

    .select2-container--bootstrap4 .select2-selection__choice__remove {
        color: white;
        font-size: 12px;
        padding: 0 4px;
    }

    .form-control[type="date"] {
        background-color: white;
        border: 1px solid #ced4da;
        padding: 8px 12px;
        border-radius: 4px;
    }

    .tache-description {
        resize: vertical;
    }

    @media (max-width: 768px) {
        .tache-item {
            margin-bottom: 10px;
        }
        
        .tache-item .row {
            margin-bottom: 10px;
        }
        
        .remove-tache {
            padding: 4px 8px;
        }
    }

    .color-option {
        display: inline-block;
        width: 30px;
        height: 30px;
        margin: 3px;
        border: 2px solid transparent;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .color-option:hover {
        transform: scale(1.1);
        box-shadow: 0 0 5px rgba(0,0,0,0.3);
    }

    .color-option.selected {
        border-color: #333;
        transform: scale(1.1);
        box-shadow: 0 0 5px rgba(0,0,0,0.5);
    }

    .color-preview {
        display: inline-block;
        width: 100%;
        height: 30px;
        border-radius: 4px;
        vertical-align: middle;
        border: 1px solid #ddd;
    }

    .color-options-container {
        display: flex;
        margin-top: 5px;
        overflow-y: auto;
    }

    /* Calendar Styles */
    .fc {
        font-size: 14px;
    }

    .fc-timeline-slots td {
        min-width: 120px;
        width: 120px;
        max-width: 150px;
    }

    .fc-timeline-month-view .fc-timeline-slots td {
        min-width: 60px;
        width: 60px;
        max-width: 80px;
    }

    .fc-timeline-week-view .fc-timeline-slots td {
        min-width: 100px;
        width: 100px;
        max-width: 120px;
    }

    .fc-timeline-day-view .fc-timeline-slots td {
        min-width: 200px;
        width: 200px;
        max-width: 250px;
    }

    .fc-timeline-header {
        overflow: visible !important;
    }

    .fc-scrollgrid-section-body > table {
        width: 100% !important;
    }

    .fc-timeline-slot-frame {
        height: 100%;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .fc-col-header-cell-cushion {
        color: #035082;
        font-weight: 600;
    }

    .fc-timeline-slot-cushion {
        color: #035082;
        font-weight: 500;
    }

    .fc-day-sat .fc-timeline-slot-cushion,
    .fc-day-sun .fc-timeline-slot-cushion {
        color: #5a7a8a;
        font-weight: normal;
    }

    .fc-day-sat .fc-timeline-slot-cushion,
    .fc-day-sun .fc-timeline-slot-cushion {
        color: #999;
        font-weight: normal;
    }

    .fc-day-sun .fc-timeline-slot-cushion::after {
        content: ' (Dimanche)';
        font-size: 0.8em;
        opacity: 0.8;
    }

    .fc-day-sat .fc-timeline-slot-cushion::after {
        content: ' (Samedi)';
        font-size: 0.8em;
        opacity: 0.8;
    }

    .fc-day-sat .fc-event,
    .fc-day-sun .fc-event {
        opacity: 0.7;
        filter: grayscale(20%);
    }

    .card {
        border: none;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
        border-radius: 0.35rem;
        overflow: hidden;
    }

    .card-header {
        background-color: #f8f9fc;
        border-bottom: 1px solid #e3e6f0;
        padding: 0.75rem 1.25rem;
    }

    .fc-header-toolbar {
        margin-bottom: 1.5em;
        padding: 0 1rem;
        flex-wrap: wrap;
        gap: 0.5rem;
    }

    .fc-toolbar-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: #035082;
    }

    .fc-button {
        color: #035082;
        border: none;
        color: white;
        padding: 0.375rem 0.75rem;
        border-radius: 0.35rem;
        font-weight: 500;
        transition: all 0.2s;
    }

    .fc-button:hover {
        background-color: #2e59d9;
        transform: translateY(-1px);
    }

    .fc-button-active {
        background-color: #2e59d9;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }

    .fc-timeline-header {
        background-color: #f8f9fc;
    }

    .fc-timeline-slot {
        border-color: #e3e6f0;
    }

    .fc-timeline-slot-label {
        font-weight: 600;
        color: #5a5c69;
    }

    .fc-datagrid-cell-main {
        font-weight: 600;
        color: #035082;
    }

    .fc-event {
        border-radius: 0.25rem;
        border: none;
        padding: 0.25rem 0.5rem;
        font-size: 0.85rem;
        box-shadow: 0 0.15rem 0.5rem rgba(0, 0, 0, 0.08);
        transition: all 0.2s;
    }

    .fc-event:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        transform: translateY(-1px);
    }

    .fc-event-title {
        font-weight: 500;
    }

    .fc-day-today {
        background-color: rgba(78, 115, 223, 0.1) !important;
    }

    ::-webkit-scrollbar {
        width: 8px;
        height: 8px;
    }

    ::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    ::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 4px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }

    .color-option {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 4px 8px;
    }

    .color-option .color-swatch {
        width: 20px;
        height: 20px;
        border-radius: 4px;
    }

    .color-option .color-code {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    /* NEW SIDEBAR STYLES */
    /* .timeline-layout {
        display: flex;
        height: calc(100vh - 100px);
        position: relative;
    } */

    .timeline-sidebar {
        position: fixed;
        top: 0;
        left: -350px; /* Hidden by default */
        width: 350px;
        height: 100vh;
        background: white;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1050;
        transition: left 0.3s ease;
        overflow-y: auto;
        border-right: 1px solid #e3e6f0;
    }

    .timeline-sidebar.active {
        left: 0;
    }

    .timeline-content {
        flex: 1;
        width: 100%;
        /* Removed transition and margin-left changes */
    }

    /* Removed sidebar-open class styles */

    .sidebar-header {
        padding: 1.5rem;
        border-bottom: 1px solid #e3e6f0;
        background: #f8f9fc;
        position: sticky;
        top: 0;
        z-index: 10;
    }

    .sidebar-close {
        position: absolute;
        top: 15px;
        right: 15px;
        background: none;
        border: none;
        font-size: 1.5rem;
        color: #6c757d;
        cursor: pointer;
        padding: 0;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .sidebar-close:hover {
        color: #343a40;
    }

    .sidebar-content {
        padding: 1.5rem;
    }

    /* Tab styles for sidebar */
    .sidebar-tabs {
        display: flex;
        margin-bottom: 1.5rem;
        border-bottom: 1px solid #e3e6f0;
    }

    .sidebar-tab {
        flex: 1;
        padding: 0.75rem 1rem;
        background: none;
        border: none;
        border-bottom: 2px solid transparent;
        cursor: pointer;
        transition: all 0.2s;
        font-size: 0.9rem;
        color: #6c757d;
    }

    .sidebar-tab:hover {
        color: #025182;
        background: #f8f9fc;
    }

    .sidebar-tab.active {
        color: #025182;
        border-bottom-color: #025182;
        font-weight: 500;
    }

    .sidebar-tab-content {
        display: none;
    }

    .sidebar-tab-content.active {
        display: block;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .timeline-sidebar {
            width: 100%;
            left: -100%;
        }
        
        .timeline-sidebar.active {
            left: 0;
        }
    }

    /* Form styling in sidebar */
    .sidebar-content .form-group {
        margin-bottom: 1rem;
    }

    .sidebar-content .form-control {
        font-size: 0.9rem;
    }

    .sidebar-content .btn {
        font-size: 0.9rem;
    }

    /* Overlay for mobile */
    .sidebar-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        z-index: 1040;
        opacity: 0;
        visibility: hidden;
        transition: all 0.3s ease;
    }

    .sidebar-overlay.active {
        opacity: 1;
        visibility: visible;
    }

    @media (min-width: 769px) {
        .sidebar-overlay {
            display: none;
        }
    }


/* Drag and Drop Visual Feedback */

 
.fc-event {
    cursor: grab;
    transition: all 0.2s ease;
}

.fc-event:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    z-index: 999;
}

.fc-event:active {
    cursor: grabbing;
}

/* Event being dragged */
.fc-event-dragging {
    opacity: 0.8;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
    transform: rotate(2deg);
    z-index: 1000;
}

/* Drop zones highlighting */
.fc-highlight {
    background-color: rgba(78, 115, 223, 0.2) !important;
    border: 2px dashed #4e73df !important;
    animation: pulse 1s infinite;
}

@keyframes  pulse {
    0% { opacity: 0.6; }
    50% { opacity: 1; }
    100% { opacity: 0.6; }
}

/* Resize handles */
.fc-event-resizer {
    background: rgba(255, 255, 255, 0.8);
    border: 1px solid #ccc;
    width: 8px;
    height: 8px;
    border-radius: 50%;
}

.fc-event-resizer:hover {
    background: white;
    border-color: #4e73df;
}

/* Loading state for events */
.fc-event.event-loading {
    opacity: 0.6;
    pointer-events: none;
    position: relative;
}

.event-loading {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 10px;
    color: white;
    text-shadow: 1px 1px 1px rgba(0,0,0,0.8);
    z-index: 10;
}

/* Resource highlighting during drag */
.fc-resource-timeline-divider {
    transition: background-color 0.2s ease;
}

.fc-timeline-slot:hover {
    background-color: rgba(78, 115, 223, 0.05);
}

/* Weekend styling for better visual distinction */
.fc-day-sat, .fc-day-sun {
    background-color: rgba(0, 0, 0, 0.02);
}

/* Event content styling */
.fc-event-main {
    padding: 2px 4px;
}

.fc-event-title {
    font-weight: 500;
    font-size: 0.85em;
    line-height: 1.2;
}

/* Duplicate indicator */
.fc-event[title*="Copie"], .fc-event[title*="copie"] {
    border-left: 4px solid #ffc107;
}

/* Employee resource styling */
.fc-datagrid-cell-main {
    font-weight: 600;
    color: #035082;
    padding: 8px 12px;
}

/* Resource hover effect */
.fc-datagrid-cell:hover {
    background-color: rgba(78, 115, 223, 0.05);
}

/* Instructions banner styling */
.drag-drop-instructions {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 12px 20px;
    border-radius: 8px;
    margin-bottom: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.drag-drop-instructions h6 {
    margin-bottom: 10px;
    font-weight: 600;
}

.drag-drop-instructions ul {
    margin-bottom: 0;
    padding-left: 20px;
}

.drag-drop-instructions li {
    margin-bottom: 5px;
    font-size: 0.9em;
}

.drag-drop-instructions strong {
    color: #ffd700;
}

/* Mobile responsive adjustments */
@media (max-width: 768px) {
    .fc-event {
        font-size: 0.75em;
        padding: 1px 2px;
    }
    
    .fc-event:hover {
        transform: none; /* Disable hover effects on mobile */
    }
    
    .fc-event-resizer {
        width: 12px;
        height: 12px;
    }
    
    .drag-drop-instructions {
        padding: 8px 15px;
        font-size: 0.85em;
    }
}

/* Context menu styling (for future enhancements) */
.event-context-menu {
    position: absolute;
    background: white;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    z-index: 1100;
    min-width: 150px;
    padding: 5px 0;
}

.event-context-menu-item {
    padding: 8px 15px;
    cursor: pointer;
    font-size: 0.9em;
    transition: background-color 0.2s;
}

.event-context-menu-item:hover {
    background-color: #f8f9fa;
}

.event-context-menu-item i {
    width: 16px;
    margin-right: 8px;
}

/* Success/error feedback animations */
.fc-event.animate-success {
    animation: successPulse 0.6s ease-in-out;
}

.fc-event.animate-error {
    animation: errorShake 0.6s ease-in-out;
}

@keyframes  successPulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); background-color: #28a745; }
    100% { transform: scale(1); }
}

@keyframes  errorShake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-5px); }
    75% { transform: translateX(5px); }
} 

/* Holiday styling */
.fc-event.holiday-event {
    opacity: 0.3;
    border: 2px dashed #ff9800;
    background-color: #fff3e0 !important;
    color: #e65100;
    font-weight: bold;
    pointer-events: none; /* Make read-only */
}

/* Absence styling */
.fc-event.absence-event {
    border-left: 4px solid currentColor;
    font-style: italic;
}

.fc-event.absence-event[title*="Absence"] {
    background-color: #f44336;
}

.fc-event.absence-event[title*="Congé individuel"] {
    background-color: #9c27b0;
}

.fc-event.absence-event[title*="Congé collectif"] {
    background-color: #673ab7;
}

/* Weekend + Holiday combination */
.fc-day-sat.fc-day-holiday,
.fc-day-sun.fc-day-holiday {
    background-color: #ffecb3;
}

/* Resource drag and drop styles */
.fc-datagrid-cell.fc-resource {
    transition: all 0.2s ease;
    position: relative;
}

.fc-datagrid-cell.fc-resource[draggable="true"]:hover {
    background-color: rgba(78, 115, 223, 0.05);
}

.fc-datagrid-cell.fc-resource[draggable="true"] {
    cursor: grab;
}

.fc-datagrid-cell.fc-resource[draggable="true"]:active {
    cursor: grabbing;
}

.drag-handle {
    opacity: 0.6;
    transition: opacity 0.2s ease;
}

.fc-datagrid-cell.fc-resource:hover .drag-handle {
    opacity: 1;
}

/* Visual feedback during drag */
.resource-dragging {
    opacity: 0.6 !important;
    transform: scale(0.98);
}

.fc-datagrid-cell.fc-resource.drag-over {
    background-color: rgba(78, 115, 223, 0.2) !important;
    border-top: 3px solid #4e73df !important;
}

/* Smooth transitions for reordering */
.fc-datagrid-cell.fc-resource {
    transition: all 0.3s ease;
}

tr {
    transition: transform 0.3s ease;
}



/* Force calendar to auto-size to content */
#calendar {
    height: auto !important;
}

.fc {
    height: auto !important;
}

.fc-timeline-body {
    height: auto !important;
    min-height: auto !important;
}

.fc-scrollgrid {
    height: auto !important;
}

.fc-scrollgrid-section-body {
    height: auto !important;
}

.fc-datagrid-body {
    height: auto !important;
}

/* Remove any fixed heights that might cause extra space */
.fc-scroller {
    height: auto !important;
    max-height: none !important;
}


.select2-container .select2-selection--single{
    min-height:60px;
}

</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div class="btn-group mr-3" role="group" aria-label="Vue">
        <a href="<?php echo e(route('admin.timeline-employees')); ?>" class="btn btn-primary"><i class="fas fa-hard-hat"></i> Vue Par Salariés</a>
        <a href="<?php echo e(route('admin.planning')); ?>" class="btn btn-outline-primary"><i class="fa-regular fa-calendar"></i> Calendrier Chantiers</a>
        <a href="<?php echo e(route('admin.timeline-chantier')); ?>" class="btn btn-outline-primary"><i class="fa-solid fa-timeline"></i> Chronologie des Chantiers</a>

        <button onclick="captureCalendar()" class="btn btn-outline-success"><i class="fas fa-camera"></i> Capturer Planning</button>
    </div>
    
</div>


<div class="timeline-layout">
    
    
    <!-- Sidebar -->
    <div class="timeline-sidebar" id="timelineSidebar">
        <div class="sidebar-header">
            <h5 class="mb-0" id="sidebarTitle">Ajouter un événement</h5>
            <button type="button" class="sidebar-close" id="closeSidebar">
                <span>&times;</span>
            </button>
        </div>
        
        <div class="sidebar-content">
            <form id="employeeEventForm">
                <input type="hidden" name="employee_id" id="employee_id">
                
                <!-- Tab Navigation -->
                <div class="sidebar-tabs">
                    <button type="button" class="sidebar-tab active" data-tab="details">
                        <i class="fas fa-info-circle me-1"></i> Détails
                    </button>
                    <button type="button" class="sidebar-tab" data-tab="chantier">
                        <i class="fas fa-hard-hat me-1"></i> Chantier
                    </button>
                    <button type="button" class="sidebar-tab" data-tab="taches">
                        <i class="fas fa-tasks me-1"></i> Tâches
                    </button>
                </div>

                <!-- Tab Contents -->
                <div class="sidebar-tab-content active" id="details-tab">
                    <div class="form-group">
                        <label>Nom de l'événement</label>
                        <input type="text" class="form-control" id="event_name" name="event_name" required>
                    </div>
                    <div class="form-group">
                        <label>Date de début</label>
                        <input type="date" class="form-control" id="event_start_date" name="event_start_date" required>
                    </div>
                    <div class="form-group">
                        <label>Date de fin</label>
                        <input type="date" class="form-control" id="event_end_date" name="event_end_date" required>
                    </div>
                    <div class="form-group">
                        <label>Note</label>
                        <textarea class="form-control" id="event_note" name="event_note" rows="3"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Couleur de l'événement</label>
                        <div class="d-flex align-items-center">
                            <div id="selectedColorPreview" class="color-preview"></div>
                            <input type="hidden" id="event_color" name="event_color" value="#52357B">
                        </div>
                        <div class="btn-group w-100 mt-2" role="group">
                            <button type="button" class="btn btn-outline-primary active" id="colorPresetBtn">Palette</button>
                            <button type="button" class="btn btn-outline-primary" id="colorPickerBtn">Sélection personnalisée</button>
                        </div>
                        <div id="colorPresetContainer" class="mt-2">
                            <div id="colorOptions" class="color-options-container mt-2">
                                <!-- Color options will be added by JavaScript -->
                            </div>
                        </div>
                        <div id="colorPickerContainer" class="d-none mt-2">
                            <input type="color" id="customColorPicker" class="form-control form-control-color" value="#52357B">
                        </div>
                    </div>
                </div>

                <!-- Chantier Tab -->
                <div class="sidebar-tab-content" id="chantier-tab">
                    <div class="btn-group w-100 mb-3" role="group">
                        <button type="button" class="btn btn-outline-primary active" id="newChantierBtn">Nouveau chantier</button>
                        <button type="button" class="btn btn-outline-primary" id="existingChantierBtn">Chantier existant</button>
                    </div>

                    <!-- New Chantier Fields -->
                    <div id="newChantierSection">
                        <div class="form-group">
                            <label>Nom du chantier</label>
                            <input type="text" class="form-control" id="new_chantier_nom" name="new_chantier_nom" required>
                        </div>
                        <div class="form-group">
                            <label>Adresse</label>
                            <input type="text" class="form-control" id="new_chantier_adresse" name="new_chantier_adresse" required>
                        </div>
                        <div class="form-group">
                            <label>Date de début</label>
                            <input type="date" class="form-control" id="new_chantier_date_debut" name="new_chantier_date_debut" required>
                        </div>
                        <div class="form-group">
                            <label>Date de fin</label>
                            <input type="date" class="form-control" id="new_chantier_date_fin" name="new_chantier_date_fin" required>
                        </div>
                    </div>

                    <!-- Existing Chantier Select -->
                    <div id="existingChantierSection" class="d-none">
                        <div class="form-group">
                            <label>Sélectionner un chantier existant</label>
                            <select class="js-example-basic-multiple form-control w-100" id="existing_chantier_id" name="existing_chantier_id"  style="width:100%;">
                                <option value="">Sélectionner un chantier</option>
                                <?php $__currentLoopData = $chantiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chantier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($chantier->id); ?>"><?php echo e($chantier->nom); ?> (<?php echo e($chantier->adresse); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Tâches Tab -->
                <div class="sidebar-tab-content" id="taches-tab">
                    <div class="form-group">
                        <div id="tachesContainer">
                            
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addTacheBtn">
                            <i class="fas fa-plus"></i> Ajouter une nouvelle tâche
                        </button>
                    </div>
                </div>

                <div class="border-top pt-3 mt-4">
                    <button type="button" class="btn btn-secondary mr-2" id="cancelSidebar">Annuler</button>
                    <button type="button" class="btn btn-primary" id="saveEmployeeEvent">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Edit Sidebar -->
    <div class="timeline-sidebar" id="editTimelineSidebar">
        <div class="sidebar-header">
            <h5 class="mb-0">Modifier l'événement</h5>
            <button type="button" class="sidebar-close" id="closeEditSidebar">
                <span>&times;</span>
            </button>
        </div>
        
        <div class="sidebar-content">
            <form id="editEventForm">
                <input type="hidden" id="edit-event-id">
                
                <!-- Tab Navigation -->
                <div class="sidebar-tabs">
                    <button type="button" class="sidebar-tab active" data-tab="edit-details">
                        <i class="fas fa-info-circle me-1"></i> Détails
                    </button>
                    <button type="button" class="sidebar-tab" data-tab="edit-chantier">
                        <i class="fas fa-hard-hat me-1"></i> Chantier
                    </button>
                    <button type="button" class="sidebar-tab" data-tab="edit-taches">
                        <i class="fas fa-tasks me-1"></i> Tâches
                    </button>
                </div>

                <!-- Tab Contents -->
                <div class="sidebar-tab-content active" id="edit-details-tab">
                    <div class="form-group">
                        <label for="edit-name" class="form-label">Nom de l'événement</label>
                        <input type="text" class="form-control" id="edit-name" name="edit-name" required>
                    </div>
                    <div class="form-group">
                        <label for="edit-employee" class="form-label">Employé</label>
                        <select class="form-control" id="edit-employee" required>
                            <option value="" disabled>Sélectionner un employé</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>">
                                    <?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?> - 
                                    <?php
                                        $metierNames = [];
                                        if ($employee->primary_metiers) {
                                            $metierIds = json_decode($employee->primary_metiers, true);
                                            foreach ($metierIds as $id) {
                                                $metier = \App\Models\Metier::find($id);
                                                if ($metier) {
                                                    $metierNames[] = $metier->nom;
                                                }
                                            }
                                        }
                                    ?>
                                    <?php echo e(implode(', ', $metierNames)); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="edit-date-debut" class="form-label">Date début</label>
                        <input type="date" class="form-control" id="edit-date-debut" required>
                    </div>
                    <div class="form-group">
                        <label for="edit-date-fin" class="form-label">Date fin</label>
                        <input type="date" class="form-control" id="edit-date-fin" required>
                    </div>
                    <div class="form-group">
                        <label for="edit-note" class="form-label">Note</label>
                        <textarea class="form-control" id="edit-note" rows="3"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="edit-event-color" class="form-label">Couleur</label>
                        <div class="d-flex align-items-center">
                            <div id="edit-selectedColorPreview" class="color-preview"></div>
                            <input type="hidden" id="edit-event-color" name="event_color" value="#52357B">
                        </div>
                        <div class="btn-group w-100 mt-2" role="group">
                            <button type="button" class="btn btn-outline-primary active" id="edit-colorPresetBtn">Palette</button>
                            <button type="button" class="btn btn-outline-primary" id="edit-colorPickerBtn">Sélection personnalisée</button>
                        </div>
                        <div id="edit-colorPresetContainer" class="mt-2">
                            <div id="edit-colorOptions" class="color-options-container mt-2">
                                <!-- Color options will be added by JavaScript -->
                            </div>
                        </div>
                        <div id="edit-colorPickerContainer" class="d-none mt-2">
                            <input type="color" id="edit-customColorPicker" class="form-control form-control-color" value="#52357B">
                        </div>
                    </div>
                </div>

                <!-- Chantier Tab -->
                <div class="sidebar-tab-content" id="edit-chantier-tab">
                    <div class="form-group">
                        <label for="edit-chantier" class="form-label">Chantier</label>
                        <select class="form-control js-example-basic-single" id="edit-chantier">
                            <option value="">Sélectionner un chantier</option>
                            <?php $__currentLoopData = $chantiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chantier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($chantier->id); ?>"><?php echo e($chantier->nom); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="edit-chantier-date_de_debut" class="form-label">Date début</label>
                        <input type="date" class="form-control" id="edit-chantier-date_de_debut" required>
                    </div>
                    <div class="form-group">
                        <label for="edit-chantier-date_de_fin" class="form-label">Date fin</label>
                        <input type="date" class="form-control" id="edit-chantier-date_de_fin" required>
                    </div>
                </div>

                <!-- Tâches Tab -->
                <div class="sidebar-tab-content" id="edit-taches-tab">
                    <h6><strong>Tâches associées</strong></h6>
                    <div id="edit-taches-list"></div>
                    <div class="form-group">
                        <div id="edit-taches-container">
                            
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="edit-add-tache-btn">
                            <i class="fas fa-plus"></i> Ajouter une nouvelle tâche
                        </button>
                    </div>
                </div>

                <div class="border-top pt-3 mt-4">
                <button type="button" class="btn btn-primary btn-block mb-2" id="updateEmployeeEvent"><i class="fa-solid fa-save"></i> Mettre à jour</button>
                    <button type="button" class="btn btn-secondary btn-block mr-2" id="cancelEditSidebar">Annuler</button>
                    <button type="button" class="btn btn-danger btn-block mr-2" id="deleteEventBtn"><i class="fa-solid fa-trash"></i> Supprimer</button>
                </div>
            </form>
        </div>
    </div>

    

    <!-- Overlay for mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>


    <!-- Main Timeline Content -->
    <div class="timeline-content" id="timelineContent">

    <div class="alert alert-info mb-3 d-none" id="compactInstructions">
        <button type="button" class="close" data-dismiss="alert">&times;</button>
        <strong><i class="fas fa-lightbulb"></i> Astuce:</strong> 
        Glissez les événements pour les déplacer • Redimensionnez en tirant les bords • Ctrl+Clic pour dupliquer
    </div>

        <div class="card">
            <div class="card-body">
                <!-- style="min-height: 100vh;" -->
                <div id="calendar" ></div> 
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    // Sidebar functionality
    function openSidebar(type = 'add') {
        // Close any currently open sidebar first
        closeSidebar('add', false);
        closeSidebar('edit', false);
        
        const sidebar = type === 'add' ? document.getElementById('timelineSidebar') : document.getElementById('editTimelineSidebar');
        const overlay = document.getElementById('sidebarOverlay');
        
        sidebar.classList.add('active');
        overlay.classList.add('active');
    }

    // Update the closeSidebar function to reset forms
    function closeSidebar(type = 'add', resetForm = false) {
        const sidebar = type === 'add' ? document.getElementById('timelineSidebar') : document.getElementById('editTimelineSidebar');
        const overlay = document.getElementById('sidebarOverlay');
        
        sidebar.classList.remove('active');
        overlay.classList.remove('active');
        
        // Reset form when closing add sidebar
        if (type === 'add' && resetForm) {
            setTimeout(() => resetAddForm(), 300); // Wait for animation to complete
        }
    }

    // Tab switching for sidebars
    function switchTab(tabName, sidebarType = 'add') {
        const prefix = sidebarType === 'add' ? '' : 'edit-';
        const tabButtons = document.querySelectorAll(`#${sidebarType === 'add' ? 'timelineSidebar' : 'editTimelineSidebar'} .sidebar-tab`);
        const tabContents = document.querySelectorAll(`#${sidebarType === 'add' ? 'timelineSidebar' : 'editTimelineSidebar'} .sidebar-tab-content`);
        
        // Remove active class from all tabs and contents
        tabButtons.forEach(btn => btn.classList.remove('active'));
        tabContents.forEach(content => content.classList.remove('active'));
        
        // Activate clicked tab and corresponding content
        document.querySelector(`[data-tab="${prefix}${tabName}"]`).classList.add('active');
        document.getElementById(`${prefix}${tabName}-tab`).classList.add('active');
    }

    // Event listeners
    document.addEventListener('DOMContentLoaded', function() {

        if (!localStorage.getItem('compactInstructionsShown')) {
            const compactAlert = document.getElementById('compactInstructions');
            if (compactAlert) {
                compactAlert.classList.remove('d-none');
            }
        }

        if (!localStorage.getItem('astuceManipulationShown')) {
            const astuceAlert = document.getElementById('astuceManipulation');
            if (astuceAlert) {
                astuceAlert.classList.remove('d-none');
            }
        }

        // Handle close button clicks and set localStorage
        $(document).on('click', '#compactInstructions .close', function() {
            localStorage.setItem('compactInstructionsShown', 'true');
        });

        $(document).on('click', '#astuceManipulation .close', function() {
            localStorage.setItem('astuceManipulationShown', 'true');
        });

        // Handle Bootstrap's alert close event
        $('#compactInstructions').on('closed.bs.alert', function () {
            localStorage.setItem('compactInstructionsShown', 'true');
        });

        $('#astuceManipulation').on('closed.bs.alert', function () {
            localStorage.setItem('astuceManipulationShown', 'true');
        });
        
        // Optional: Add a help button to show/hide full instructions
        const helpButton = `
            <button type="button" class="btn btn-outline-info btn-sm" id="toggleInstructions" title="Afficher/Masquer les instructions">
                <i class="fas fa-question-circle"></i>
            </button>
        `;

        
        // Close sidebar buttons
        document.getElementById('closeSidebar').addEventListener('click', () => closeSidebar('add', true));
        document.getElementById('closeEditSidebar').addEventListener('click', () => closeSidebar('edit', false));
        document.getElementById('cancelSidebar').addEventListener('click', () => closeSidebar('add', true));
        document.getElementById('cancelEditSidebar').addEventListener('click', () => closeSidebar('edit', false));

        // Overlay click
        document.getElementById('sidebarOverlay').addEventListener('click', () => {
            closeSidebar('add', true);
            closeSidebar('edit', false);
        });

        // Tab switching for add sidebar
        document.querySelectorAll('#timelineSidebar .sidebar-tab').forEach(tab => {
            tab.addEventListener('click', function() {
                const tabName = this.getAttribute('data-tab');
                switchTab(tabName, 'add');
            });
        });

        // Tab switching for edit sidebar
        document.querySelectorAll('#editTimelineSidebar .sidebar-tab').forEach(tab => {
            tab.addEventListener('click', function() {
                const tabName = this.getAttribute('data-tab').replace('edit-', '');
                switchTab(tabName, 'edit');
            });
        });
    });

    function addEditTacheItem(id = '', nom = '', description = '', startDate = '', endDate = '', status = 'pending') {
        const tacheId = id || 'new-' + Date.now();
        const tacheItem = `
            <div class="tache-item" data-tache-id="${tacheId}">
                <div class="row bg-light mb-2 p-2">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-12">
                                <label>Nom de la tâche:</label>
                                <input type="text" class="form-control tache-nom" 
                                       value="${nom}" 
                                       placeholder="Nom de la tâche" 
                                       data-field="nom" required>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Description:</label>
                                <textarea class="form-control tache-description" 
                                         placeholder="Description" 
                                         rows="2" 
                                         data-field="description">${description || ''}</textarea>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Date début de tâche:</label>
                                <input type="date" 
                                       class="form-control tache-date-debut" 
                                       value="${formatDateForInput(startDate)}" 
                                       data-field="date_debut">
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Date fin de tâche:</label>
                                <input type="date" 
                                       class="form-control tache-date-fin" 
                                       value="${formatDateForInput(endDate)}" 
                                       data-field="date_fin">
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Statut</label>
                                <select class="form-control tache-status" data-field="status">
                                    <option value="pending" ${status === 'pending' ? 'selected' : ''}>En Attente</option>
                                    <option value="in_progress" ${status === 'in_progress' ? 'selected' : ''}>En Cours</option>
                                    <option value="completed" ${status === 'completed' ? 'selected' : ''}>Complété</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 align-self-center">
                        <button type="button" class="btn btn-danger btn-sm btn-block remove-tache">
                            <i class="fas fa-trash"></i> Supprimer
                        </button>
                    </div>
                </div>
            </div>
        `;

        const container = document.getElementById('edit-taches-container');
        const div = document.createElement('div');
        div.innerHTML = tacheItem;
        container.appendChild(div.firstElementChild);

        // Add click handler for the remove button
        $('.remove-tache').last().on('click', function() {
            $(this).closest('.tache-item').remove();
        });
    }

    // Initialize remove handlers for existing tasks
    document.addEventListener('DOMContentLoaded', () => {
        // Add click handlers for existing remove buttons
        $('.remove-tache').on('click', function() {
            $(this).closest('.tache-item').remove();
        });
    });

    // Add click handler for the add tache button in edit sidebar
    document.getElementById('edit-add-tache-btn')?.addEventListener('click', function() {
        addEditTacheItem();
    });

    // Function to load taches when editing an event
    function loadTachesForEdit(taches) {
        const container = document.getElementById('edit-taches-container');
        container.innerHTML = ''; // Clear existing taches
        
        if (taches && taches.length > 0) {
            taches.forEach(tache => {
                addEditTacheItem(
                    tache.id,
                    tache.nom,
                    tache.description,
                    tache.date_debut,
                    tache.date_fin,
                    tache.status
                );
            });
        }
    }

    function initColorPicker() {
        const colorOptions = document.getElementById('colorOptions');
        const colorInput = document.getElementById('event_color');
        const colorPreview = document.getElementById('selectedColorPreview');
        const colorPresetBtn = document.getElementById('colorPresetBtn');
        const colorPickerBtn = document.getElementById('colorPickerBtn');
        const colorPresetContainer = document.getElementById('colorPresetContainer');
        const colorPickerContainer = document.getElementById('colorPickerContainer');
        const customColorPicker = document.getElementById('customColorPicker');
        
        const eventColors = [
            '#52357B', '#4F1C51', '#604652', '#522546', '#3D365C', '#393E46', '#641B2E', '#533B4D', '#4B352A',
            '#2A4759', '#333446', '#332D56', '#6B8C9E', '#948979', '#8B9D83', '#657C6A', '#73946B', '#537D5D',
            '#626F47', '#6F826A', '#67AE6E', '#A4B465', '#9E7B6F', '#7D8A8A', '#A08963', '#706D54', '#5A827E',
            '#8A784E', '#5409DA', '#7965C1', '#4E71FF', '#7F55B1', '#4300FF', '#5459AC', '#483AA0', '#7C4585',
            '#27548A', '#096B68', '#129990', '#4E6688', '#007074', '#27548A', '#077A7D', '#03A791', '#169976',
            '#328E6E', '#1DCD9F', '#85193C', '#A86523', '#AF3E3E', '#D5451B', '#A55B4B', '#A76545', '#88304E',
            '#BE5B50', '#8A2D3B', '#A86523', '#BB3E00', '#C5172E', '#A53860', '#CD5656', '#BF9264', '#DDA853',
            '#CA7842', '#E9A319', '#F97A00', '#FF9B45', '#DA6C6C', '#FE5D26', '#FFAAAA', '#C95792', '#FF9898',
            '#FAA4BD', '#F564A9', '#3A0519', '#3A0519', '#183B4E', '#3B3B1A', '#210F37', '#0E2148', '#16610E',
            '#521C0D', '#06202B', '#222831', '#00CAFF', '#0065F8', '#C68EFD', '#B6B09F', '#84AE92', '#B6B09F',
            '#B0DB9C', '#AEC8A4', '#71C0BB', '#8DBCC7', '#9B7EBD', '#7F8CAA', '#90C67C', '#648DB3'
        ];

        // Only initialize if not already done
        if (colorOptions.children.length === 0) {
            // Add color options
            eventColors.forEach((color, index) => {
                const colorEl = document.createElement('div');
                colorEl.className = 'color-option' + (index === 0 ? ' selected' : '');
                colorEl.style.backgroundColor = color;
                colorEl.dataset.color = color;
                
                colorEl.addEventListener('click', function() {
                    // Remove selected class from all options
                    document.querySelectorAll('.color-option').forEach(opt => {
                        opt.classList.remove('selected');
                    });
                    
                    // Add selected class to clicked option
                    this.classList.add('selected');
                    
                    // Update hidden input and preview
                    const selectedColor = this.dataset.color;
                    colorInput.value = selectedColor;
                    colorPreview.style.backgroundColor = selectedColor;
                });
                
                colorOptions.appendChild(colorEl);
            });
            
            // Set initial preview if not set
            if (colorInput.value && !colorPreview.style.backgroundColor) {
                colorPreview.style.backgroundColor = colorInput.value;
            }
        }

        // Function to update the color preview and hidden input
        function updateColor(color) {
            colorInput.value = color;
            colorPreview.style.backgroundColor = color;
            
            // Update the custom color picker value if it's a custom color
            if (!eventColors.includes(color)) {
                customColorPicker.value = color;
            }
        }

        // Handle custom color picker change
        customColorPicker.addEventListener('input', function() {
            updateColor(this.value);
        });

        // Toggle between preset and custom color picker
        colorPresetBtn.addEventListener('click', function() {
            colorPresetBtn.classList.add('active');
            colorPickerBtn.classList.remove('active');
            colorPresetContainer.classList.remove('d-none');
            colorPickerContainer.classList.add('d-none');
        });

        colorPickerBtn.addEventListener('click', function() {
            colorPickerBtn.classList.add('active');
            colorPresetBtn.classList.remove('active');
            colorPickerContainer.classList.remove('d-none');
            colorPresetContainer.classList.add('d-none');
        });

        // Set initial preview
        if (colorInput.value) {
            updateColor(colorInput.value);
        }
    }

    function initEditColorPicker() {
        const colorOptions = document.getElementById('edit-colorOptions');
        const colorInput = document.getElementById('edit-event-color');
        const colorPreview = document.getElementById('edit-selectedColorPreview');
        const colorPresetBtn = document.getElementById('edit-colorPresetBtn');
        const colorPickerBtn = document.getElementById('edit-colorPickerBtn');
        const colorPresetContainer = document.getElementById('edit-colorPresetContainer');
        const colorPickerContainer = document.getElementById('edit-colorPickerContainer');
        const customColorPicker = document.getElementById('edit-customColorPicker');
        
        const eventColors = [
            '#52357B', '#4F1C51', '#604652', '#522546', '#3D365C', '#393E46', '#641B2E', '#533B4D', '#4B352A',
            '#2A4759', '#333446', '#332D56', '#6B8C9E', '#948979', '#8B9D83', '#657C6A', '#73946B', '#537D5D',
            '#626F47', '#6F826A', '#67AE6E', '#A4B465', '#9E7B6F', '#7D8A8A', '#A08963', '#706D54', '#5A827E',
            '#8A784E', '#5409DA', '#7965C1', '#4E71FF', '#7F55B1', '#4300FF', '#5459AC', '#483AA0', '#7C4585',
            '#27548A', '#096B68', '#129990', '#4E6688', '#007074', '#27548A', '#077A7D', '#03A791', '#169976',
            '#328E6E', '#1DCD9F', '#85193C', '#A86523', '#AF3E3E', '#D5451B', '#A55B4B', '#A76545', '#88304E',
            '#BE5B50', '#8A2D3B', '#A86523', '#BB3E00', '#C5172E', '#A53860', '#CD5656', '#BF9264', '#DDA853',
            '#CA7842', '#E9A319', '#F97A00', '#FF9B45', '#DA6C6C', '#FE5D26', '#FFAAAA', '#C95792', '#FF9898',
            '#FAA4BD', '#F564A9', '#3A0519', '#3A0519', '#183B4E', '#3B3B1A', '#210F37', '#0E2148', '#16610E',
            '#521C0D', '#06202B', '#222831', '#00CAFF', '#0065F8', '#C68EFD', '#B6B09F', '#84AE92', '#B6B09F',
            '#B0DB9C', '#AEC8A4', '#71C0BB', '#8DBCC7', '#9B7EBD', '#7F8CAA', '#90C67C', '#648DB3'
        ];

        // Add color options
        if (colorOptions.children.length === 0) {
            eventColors.forEach((color) => {
                const colorEl = document.createElement('div');
                colorEl.className = 'color-option';
                colorEl.style.backgroundColor = color;
                colorEl.dataset.color = color;
                
                colorEl.addEventListener('click', function() {
                    // Remove selected class from all options
                    document.querySelectorAll('#edit-colorOptions .color-option').forEach(opt => {
                        opt.classList.remove('selected');
                    });
                    
                    // Add selected class to clicked option
                    this.classList.add('selected');
                    
                    // Update hidden input and preview
                    updateColor(this.dataset.color);
                });
                
                colorOptions.appendChild(colorEl);
            });
        }

        function updateColor(color) {
            colorInput.value = color;
            colorPreview.style.backgroundColor = color;
            if (!eventColors.includes(color) && customColorPicker) {
                customColorPicker.value = color;
            }
        }

        // Handle custom color picker change
        if (customColorPicker) {
            customColorPicker.addEventListener('input', function() {
                updateColor(this.value);
            });
        }

        // Toggle between preset and custom color picker
        if (colorPresetBtn) {
            colorPresetBtn.addEventListener('click', function() {
                colorPresetBtn.classList.add('active');
                colorPickerBtn.classList.remove('active');
                colorPresetContainer.classList.remove('d-none');
                colorPickerContainer.classList.add('d-none');
            });
        }

        if (colorPickerBtn) {
            colorPickerBtn.addEventListener('click', function() {
                colorPickerBtn.classList.add('active');
                colorPresetBtn.classList.remove('active');
                colorPickerContainer.classList.remove('d-none');
                colorPresetContainer.classList.add('d-none');
            });
        }

        // Set initial preview
        if (colorInput.value) {
            updateColor(colorInput.value);
        }
    }

    function formatDateForInput(dateStr) {
        if (!dateStr) return '';
        const date = new Date(dateStr);
        return date.toISOString().split('T')[0];
    }

    // Function to add a new tache with optional dates
    function addTache(startDate = null, endDate = null) {
        const container = $('#tachesContainer');
        const tacheItem = `
            <div class="tache-item">
                <div class="row bg-light mb-1">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-12">
                                <label>Nom de la tâche:</label>
                                <input type="text" class="form-control tache-nom" placeholder="Nom de la tâche" required>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Description:</label>
                                <textarea class="form-control tache-description" placeholder="Description" rows="2"></textarea>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Date début de tâche:</label>
                                <input type="date" class="form-control tache-date-debut" placeholder="Date début" value="${formatDateForInput(startDate)}">
                            </div>
                            <div class="col-md-12 mb-1">
                                <label>Date fin de tâche:</label>
                                <input type="date" class="form-control tache-date-fin" placeholder="Date fin" value="${formatDateForInput(endDate)}">
                            </div>
                            <div class="col-md-12 mb-1">
                                <label for="status">Statut</label>
                                <select id="status" name="status" class="form-control mb-3 tache-status">
                                    <option value="pending">En Attente</option>
                                    <option value="in_progress">En Cours</option>
                                    <option value="completed">Complété</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 align-self-center">
                        <button type="button" class="btn btn-danger btn-sm btn-block remove-tache">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        container.append(tacheItem);

        // Initialize Select2 for the new select element
        $(".js-example-basic-multiple").select2();

        $(document).ready(function() {
            $('#edit-chantier').select2({
                width: '100%',
                placeholder: 'Sélectionner un chantier',
                allowClear: true
            });
            
        });

        // Add click handler for the remove button
        $('.remove-tache').last().on('click', function() {
            $(this).closest('.tache-item').remove();
        });
    }

    $('#addTacheBtn').on('click', function() {
        // Add new tache with same dates as event
        addTache($('#event_start_date').val(), $('#event_end_date').val());
    });

    

    // Handle chantier type toggle
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize the toggle buttons
        const newChantierBtn = document.getElementById('newChantierBtn');
        const existingChantierBtn = document.getElementById('existingChantierBtn');
        const newChantierSection = document.getElementById('newChantierSection');
        const existingChantierSection = document.getElementById('existingChantierSection');

        if (newChantierBtn && existingChantierBtn) {
            newChantierBtn.addEventListener('click', function() {
                this.classList.add('active');
                existingChantierBtn.classList.remove('active');
                newChantierSection.classList.remove('d-none');
                existingChantierSection.classList.add('d-none');
                
                // Make new chantier fields required
                document.querySelectorAll('#newChantierSection input').forEach(input => input.required = true);
                document.getElementById('existing_chantier_id').required = false;
            });

            existingChantierBtn.addEventListener('click', function() {
                this.classList.add('active');
                newChantierBtn.classList.remove('active');
                existingChantierSection.classList.remove('d-none');
                newChantierSection.classList.add('d-none');
                
                // Make existing chantier select required
                document.getElementById('existing_chantier_id').required = true;
                document.querySelectorAll('#newChantierSection input').forEach(input => input.required = false);
            });
        }

        $('#existing_chantier_id').select2({
            width: '100%',
            placeholder: 'Sélectionner un chantier',
            allowClear: true
        });

        $('#existing_chantier_id').on('change', function() {
            const selectedOption = $(this).find('option:selected');
            const chantierName = selectedOption.text();
            const chantierId = $(this).val();
            
            if (chantierId && chantierName) {
                const cleanChantierName = chantierName.split(' (')[0];
                $('#event_name').val(cleanChantierName);
                
                // Fetch the last used color for this chantier
                fetch('<?php echo e(route("admin.get-chantier-last-color")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        chantier_id: chantierId
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success && data.color) {
                        const lastUsedColor = data.color;
                        
                        // Set the color
                        document.getElementById('event_color').value = lastUsedColor;
                        document.getElementById('selectedColorPreview').style.backgroundColor = lastUsedColor;
                        
                        // Update the color picker selection
                        const colorOptions = document.querySelectorAll('#colorOptions .color-option');
                        colorOptions.forEach(option => option.classList.remove('selected'));
                        
                        const matchingColorOption = document.querySelector(`#colorOptions .color-option[data-color="${lastUsedColor}"]`);
                        if (matchingColorOption) {
                            matchingColorOption.classList.add('selected');
                        } else {
                            // If color not in palette, update custom color picker
                            const customColorPicker = document.getElementById('customColorPicker');
                            if (customColorPicker) {
                                customColorPicker.value = lastUsedColor;
                            }
                        }
                    } else {
                        // If no previous color found, use default
                        const defaultColor = '#52357B';
                        document.getElementById('event_color').value = defaultColor;
                        document.getElementById('selectedColorPreview').style.backgroundColor = defaultColor;
                    }
                })
                .catch(error => {
                    console.error('Error fetching chantier color:', error);
                    // Use default color on error
                    const defaultColor = '#52357B';
                    document.getElementById('event_color').value = defaultColor;
                    document.getElementById('selectedColorPreview').style.backgroundColor = defaultColor;
                });
            }
        });


    });

    let globalCalendar; // Global calendar variable

    document.addEventListener('DOMContentLoaded', function() {
        let currentEventData = null;
        var calendarEl = document.getElementById('calendar');
        
        var calendar = new FullCalendar.Calendar(calendarEl, {
            themeSystem: 'bootstrap',
            firstDay: 1,
            draggable: false,
            height: 'auto',
            locale: 'fr',
            initialView: 'resourceTimelineWeek',
            nowIndicator: false,
            headerToolbar: {
                left: 'prev,next',
                center: 'title',
                right: 'resourceTimelineDay,resourceTimelineWeek,resourceTimelineMonth'
            },
            dayHeaderFormat: {
                weekday: 'short',
                day: 'numeric',
                omitCommas: true
            },
            dayCellClassNames: function(arg) {
                const date = arg.date;
                const day = date.getDay();
                
                if (day === 0) return ['fc-day-sun'];
                if (day === 6) return ['fc-day-sat'];
                return [];
            },
            slotLabelInterval: '24:00',
            slotLabelFormat: {
                weekday: 'short',
                month: 'numeric',
                day: 'numeric'
            },
            
            schedulerLicenseKey: 'GPL-My-Project-Is-Open-Source',
            slotLabelDidMount: function(info) {
                const date = info.date;
                const weekday = date.toLocaleDateString('fr-FR', { weekday: 'long' });
                const datePart = date.toLocaleDateString('fr-FR', { day: '2-digit', month: '2-digit' });
            },
            select: function(info) {
                const resourceId = info.resource?.id;
                if (!resourceId) return;
                
                const resource = calendar.getResourceById(resourceId);
                const employeeName = resource?._resource?.title || 'Employé';
                const metier = resource?._resource?.extendedProps?.metier || '';
                
                // Show selection modal for event type
                showEventTypeModal(info, employeeName, metier, resourceId);
                
                calendar.unselect();
            },
            
            slotMinTime: '00:00:00',
            slotMaxTime: '24:00:00',
            expandRows: false,
            
            // ENABLE DRAGGING AND DROPPING
            editable: true,
            eventStartEditable: true,
            eventDurationEditable: true,
            eventResourceEditable: true, // Allow moving between employees
            
            selectable: true,
            resourceOrder: 'order',
            resourceAreaWidth: '200px',
            droppable: false,
            resourceAreaHeaderContent: 'Employés',
            resources: <?php echo json_encode($resources, 15, 512) ?>,
            events: <?php echo json_encode($events, 15, 512) ?>,
            displayEventEnd: true,
            eventDisplay: 'block',

            // Apply ordering consistently
            viewDidMount: function() {
                // Re-initialize drag and drop when view changes
                setTimeout(() => {
                    initializeResourceDragDrop();
                }, 100);
            },

            datesSet: function() {
                calendar.setOption('resourceOrder', function(resourceA, resourceB) {
                    const orderA = resourceA.extendedProps?.order || resourceA.order || 999;
                    const orderB = resourceB.extendedProps?.order || resourceB.order || 999;
                    return orderA - orderB || resourceA.title.localeCompare(resourceB.title);
                });
            },

            // DRAG AND DROP EVENT HANDLERS
            eventDrop: function(info) {
                if (info.event.extendedProps.type === 'absence') {
                    handleAbsenceMove(info);
                } else {
                    handleEventMove(info);
                }
            },

            eventResize: function(info) {
                if (info.event.extendedProps.type === 'absence') {
                    handleAbsenceResize(info);
                } else {
                    handleEventResize(info);
                }
            },

            eventClick: function(info) {
                // Check event type first
                if (info.event.extendedProps.type === 'holiday') {
                    // Holiday clicked - show info only (read-only)
                    showHolidayInfo(info.event);
                    return;
                } else if (info.event.extendedProps.type === 'absence') {
                    // Absence clicked - check if Ctrl+Cmd for duplicate
                    if (info.jsEvent.ctrlKey || info.jsEvent.metaKey) {
                        handleAbsenceDuplicate(info.event);
                    } else {
                        populateAbsenceEditModal(info.event);
                    }
                    return;
                }
                
                // Your existing event click logic for regular events...
                if (info.jsEvent.ctrlKey || info.jsEvent.metaKey) {
                    handleEventDuplicate(info.event);
                } else {
                    currentEventData = info.event;
                    populateEditModal(info.event);
                }
            },
            // Add event filtering for drag/drop
            eventAllow: function(dropInfo, draggedEvent) {
                // Prevent dragging holidays
                if (draggedEvent.extendedProps.type === 'holiday') {
                    return false;
                }
                return true;
            },
            
            resourceLabelDidMount: function(resourceObj) {
                if (resourceObj.resource._resource.avatar) {
                    const avatarEl = document.createElement('img');
                    avatarEl.src = resourceObj.resource._resource.avatar;
                    avatarEl.style.width = '24px';
                    avatarEl.style.height = '24px';
                    avatarEl.style.borderRadius = '50%';
                    avatarEl.style.marginRight = '8px';
                    resourceObj.el.querySelector('.fc-datagrid-cell-main').prepend(avatarEl);
                }
            }
        });
        
        calendar.render();

        calendar.on('datesSet', function(info) {
            // Small delay to ensure the calendar has finished rendering
            setTimeout(() => {
                // Get current resources
                const resources = calendar.getResources();
                
                // Create a copy of the resources array to avoid reference issues
                const sortedResources = [...resources].sort((a, b) => {
                    const orderA = a.extendedProps?.order ?? 999;
                    const orderB = b.extendedProps?.order ?? 999;
                    return orderA - orderB;
                });

                // Only update if the order has changed
                const currentOrder = resources.map(r => r.id).join(',');
                const newOrder = sortedResources.map(r => r.id).join(',');
                
                if (currentOrder !== newOrder) {
                    // Update the resources in the calendar
                    calendar.setOption('resources', sortedResources);
                    
                    // Force a re-render
                    calendar.render();
                }
            }, 500); // Small delay to ensure the view has been updated
        });

        globalCalendar = calendar;
        

        function initializeResourceDragDrop() {
            if (typeof globalCalendar === 'undefined') {
                setTimeout(initializeResourceDragDrop, 1000);
                return;
            }
            
            setTimeout(() => {
                // Find the employee name cells
                const resourceCells = document.querySelectorAll('.fc-datagrid-cell.fc-resource');
                
                console.log('Found resource cells:', resourceCells.length);
                
                if (resourceCells.length === 0) {
                    console.log('No resource cells found, retrying...');
                    setTimeout(initializeResourceDragDrop, 1000);
                    return;
                }
                
                resourceCells.forEach((cell, index) => {
                    const resourceId = cell.getAttribute('data-resource-id');
                    const nameSpan = cell.querySelector('.fc-datagrid-cell-main');
                    
                    if (resourceId && nameSpan) {
                        console.log(`Setting up drag for resource ${index}: ID=${resourceId}, Name=${nameSpan.textContent.trim()}`);
                        
                        // Make the cell draggable
                        cell.draggable = true;
                        cell.style.cursor = 'grab';
                        cell.style.userSelect = 'none';
                        
                        // Add visual drag handle
                        if (!nameSpan.querySelector('.drag-handle')) {
                            const handle = document.createElement('span');
                            handle.className = 'drag-handle';
                            handle.style.cssText = 'color: #ccc; margin-right: 8px; cursor: grab; font-size: 12px;';
                            handle.textContent = '⋮⋮';
                            nameSpan.insertBefore(handle, nameSpan.firstChild);
                        }
                        
                        // Clean up old listeners first
                        cell.removeEventListener('dragstart', handleDragStart);
                        cell.removeEventListener('dragover', handleDragOver);
                        cell.removeEventListener('drop', handleDrop);
                        cell.removeEventListener('dragend', handleDragEnd);
                        cell.removeEventListener('dragenter', handleDragEnter);
                        cell.removeEventListener('dragleave', handleDragLeave);
                        
                        // Add event listeners
                        cell.addEventListener('dragstart', handleDragStart);
                        cell.addEventListener('dragover', handleDragOver);
                        cell.addEventListener('drop', handleDrop);
                        cell.addEventListener('dragend', handleDragEnd);
                        cell.addEventListener('dragenter', handleDragEnter);
                        cell.addEventListener('dragleave', handleDragLeave);
                    }
                });
                
                console.log('Drag and drop initialized for', resourceCells.length, 'resource cells');
            }, 2000);
        }

        let draggedResourceId = null;
        let draggedElement = null;

        function handleDragStart(e) {
            draggedElement = e.currentTarget;
            draggedResourceId = e.currentTarget.getAttribute('data-resource-id');
            
            console.log('Drag started for resource ID:', draggedResourceId);
            
            e.currentTarget.style.opacity = '0.6';
            e.currentTarget.style.cursor = 'grabbing';
            
            e.dataTransfer.effectAllowed = 'move';
            e.dataTransfer.setData('text/html', '');
            
            // Add dragging class to both datagrid cell and timeline lane
            document.querySelectorAll(`[data-resource-id="${draggedResourceId}"]`).forEach(el => {
                el.classList.add('resource-dragging');
            });
        }

        function handleDragOver(e) {
            e.preventDefault();
            e.dataTransfer.dropEffect = 'move';
        }

        function handleDragEnter(e) {
            e.preventDefault();
            const targetCell = e.currentTarget.closest('.fc-datagrid-cell.fc-resource');
            const targetResourceId = targetCell?.getAttribute('data-resource-id');
            
            if (targetResourceId && targetResourceId !== draggedResourceId) {
                // Highlight all elements with this resource ID
                document.querySelectorAll(`[data-resource-id="${targetResourceId}"]`).forEach(el => {
                    el.style.backgroundColor = 'rgba(78, 115, 223, 0.2)';
                    if (el.classList.contains('fc-datagrid-cell')) {
                        el.style.borderTop = '3px solid #4e73df';
                    }
                });
            }
        }

        function handleDragLeave(e) {
            const targetCell = e.currentTarget.closest('.fc-datagrid-cell.fc-resource');
            const targetResourceId = targetCell?.getAttribute('data-resource-id');
            
            if (targetResourceId) {
                // Remove highlight from all elements with this resource ID
                document.querySelectorAll(`[data-resource-id="${targetResourceId}"]`).forEach(el => {
                    el.style.backgroundColor = '';
                    el.style.borderTop = '';
                });
            }
        }

        function handleDrop(e) {
            e.preventDefault();
            
            const targetCell = e.currentTarget.closest('.fc-datagrid-cell.fc-resource');
            const targetResourceId = targetCell?.getAttribute('data-resource-id');
            
            console.log('Drop event:', { draggedResourceId, targetResourceId });
            
            if (targetResourceId && draggedResourceId && targetResourceId !== draggedResourceId) {
                console.log(`Dropping resource ${draggedResourceId} onto ${targetResourceId}`);
                saveResourceOrder(draggedResourceId, targetResourceId);
            }
            
            // Clean up all highlights
            document.querySelectorAll('[data-resource-id]').forEach(el => {
                el.style.backgroundColor = '';
                el.style.borderTop = '';
                el.classList.remove('resource-dragging');
            });
        }

        function handleDragEnd(e) {
            console.log('Drag ended');
            
            e.currentTarget.style.opacity = '1';
            e.currentTarget.style.cursor = 'grab';
            
            // Clean up all highlights and classes
            document.querySelectorAll('[data-resource-id]').forEach(el => {
                el.style.backgroundColor = '';
                el.style.borderTop = '';
                el.classList.remove('resource-dragging');
            });
            
            draggedResourceId = null;
            draggedElement = null;
        }

        function saveResourceOrder(draggedResourceId, targetResourceId) {
            const orderData = {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                dragged_employee_id: draggedResourceId,
                target_employee_id: targetResourceId
            };
            
            console.log('Sending order data:', orderData);
            
            fetch('<?php echo e(route("admin.reorder-employees")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': orderData._token
                },
                body: JSON.stringify(orderData)
            })
            .then(response => response.json())
            .then(data => {
                console.log('Order response:', data);
                if (data.success) {
                    // LIVE REORDER WITHOUT REFRESH
                    reorderResourcesInDOM(draggedResourceId, targetResourceId);
                    
                    Toastify({
                        text: 'Ordre des employés mis à jour!',
                        duration: 2000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();

                    // setTimeout(() => {
                        window.location.reload();
                    // }, 1000);
                    
                } else {
                    throw new Error(data.message || 'Erreur lors de la mise à jour');
                }
            })
            .catch(error => {
                console.error('Error saving order:', error);
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function reorderResourcesInDOM(draggedResourceId, targetResourceId) {
            try {
                console.log('Reordering DOM elements:', draggedResourceId, 'before', targetResourceId);
                
                // Get the calendar instance
                const calendarEl = document.getElementById('calendar');
                const calendar = calendarEl ? calendarEl.__fullCalendar : null;
                
                if (calendar) {
                    // Get current resources
                    const resources = calendar.getResources();
                    const draggedResource = resources.find(r => r.id === draggedResourceId);
                    const targetResource = resources.find(r => r.id === targetResourceId);
                    
                    if (draggedResource && targetResource) {
                        // Remove the dragged resource
                        const draggedIndex = resources.indexOf(draggedResource);
                        resources.splice(draggedIndex, 1);
                        
                        // Find the new position
                        const targetIndex = resources.indexOf(targetResource);
                        
                        // Insert the dragged resource before the target
                        resources.splice(targetIndex, 0, draggedResource);
                        
                        // Update the resources in the calendar
                        calendar.setOption('resources', resources);
                        
                        // Force a re-render
                        calendar.render();
                        return; // Exit early since we handled it via FullCalendar's API
                    }
                }
                
                // Fallback to DOM manipulation if FullCalendar API isn't available
                const draggedElements = {
                    datagridCell: document.querySelector(`td.fc-datagrid-cell[data-resource-id="${draggedResourceId}"]`),
                    timelineLane: document.querySelector(`td.fc-timeline-lane[data-resource-id="${draggedResourceId}"]`)
                };
                
                const targetElements = {
                    datagridCell: document.querySelector(`td.fc-datagrid-cell[data-resource-id="${targetResourceId}"]`),
                    timelineLane: document.querySelector(`td.fc-timeline-lane[data-resource-id="${targetResourceId}"]`)
                };
                
                // Reorder datagrid cells (employee names)
                if (draggedElements.datagridCell && targetElements.datagridCell) {
                    const draggedRow = draggedElements.datagridCell.closest('tr');
                    const targetRow = targetElements.datagridCell.closest('tr');
                    
                    if (draggedRow && targetRow) {
                        targetRow.parentNode.insertBefore(draggedRow, targetRow);
                    }
                }
                
                // Reorder timeline lanes (event rows)
                if (draggedElements.timelineLane && targetElements.timelineLane) {
                    const draggedLaneRow = draggedElements.timelineLane.closest('tr');
                    const targetLaneRow = targetElements.timelineLane.closest('tr');
                    
                    if (draggedLaneRow && targetLaneRow) {
                        targetLaneRow.parentNode.insertBefore(draggedLaneRow, targetLaneRow);
                    }
                }
                
                // Re-initialize drag and drop for the reordered elements
                setTimeout(() => {
                    initializeResourceDragDrop();
                }, 100);
                
            } catch (error) {
                console.error('Error in DOM reorder:', error);
                // If DOM reordering fails, reload the page to show the database changes
                setTimeout(() => {
                    window.location.reload();
                }, 1000);
            }
        }
        
        // Initialize the drag and drop functionality
        initializeResourceDragDrop();
        
        // Re-initialize when calendar view changes
        globalCalendar.on('viewDidMount', function() {
            console.log('Calendar view changed, re-initializing drag drop...');
            setTimeout(initializeResourceDragDrop, 200); // Reduced timeout
        });

        function showEventTypeModal(info, employeeName, metier, resourceId) {
            const modalHtml = `
                <div class="modal fade" id="eventTypeModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-sm" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Que souhaitez-vous créer pour ${employeeName}?</h5>
                                <button type="button" class="close" data-dismiss="modal">
                                    <span>&times;</span>
                                </button>
                            </div>
                            <div class="modal-body text-center">
                                <button type="button" class="btn btn-primary btn-block mb-2" id="createEventBtn">
                                    <i class="fas fa-calendar-plus"></i> Créer un événement
                                </button>
                                <button type="button" class="btn btn-warning btn-block mb-2" id="createAbsenceBtn">
                                    <i class="fas fa-user-times"></i> Ajouter une absence
                                </button>
                                <button type="button" class="btn btn-info btn-block mb-2" id="createCongeIndividuelBtn">
                                    <i class="fas fa-user-clock"></i> Congé individuel
                                </button>
                                <button type="button" class="btn btn-secondary btn-block" id="createCongeCollectifBtn">
                                    <i class="fas fa-users-slash"></i> Congé collectif
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            
            // Remove existing modal if any
            $('#eventTypeModal').remove();
            
            // Add modal to page
            $('body').append(modalHtml);
            
            // Show modal
            $('#eventTypeModal').modal('show');
            
            // Handle button clicks
            $('#createEventBtn').click(function() {
                $('#eventTypeModal').modal('hide');
                createRegularEvent(info, employeeName, metier, resourceId);
            });
            
            $('#createAbsenceBtn').click(function() {
                $('#eventTypeModal').modal('hide');
                showAbsenceForm(info, employeeName, 'absence', resourceId);
            });
            
            $('#createCongeIndividuelBtn').click(function() {
                $('#eventTypeModal').modal('hide');
                showAbsenceForm(info, employeeName, 'conge_individuel', resourceId);
            });
            
            $('#createCongeCollectifBtn').click(function() {
                $('#eventTypeModal').modal('hide');
                showAbsenceForm(info, employeeName, 'conge_collectif', resourceId);
            });
            
            // Clean up modal when hidden
            $('#eventTypeModal').on('hidden.bs.modal', function() {
                $(this).remove();
            });
        }

        function populateAbsenceEditModal(eventData) {
            const typeLabels = {
                'absence': 'Autre',
                'conge_individuel': 'Congé individuel',
                'conge_collectif': 'Congé collectif',
            };

            const formHtml = `
                <div class="modal fade" id="editAbsenceModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Modifier ${typeLabels[eventData.extendedProps.absence_type]}</h5>
                                <button type="button" class="close" data-dismiss="modal">
                                    <span>&times;</span>
                                </button>
                            </div>
                            <form id="editAbsenceForm">
                                <div class="modal-body">
                                    <input type="hidden" id="edit_absence_id" value="${eventData.extendedProps.absence_id}">
                                    
                                    <div class="form-group">
                                        <label>Employé</label>
                                        <select class="form-control" id="edit_absence_employee_id">
                                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select class="form-control" id="edit_absence_type">
                                            <option value="absence">Autre</option>
                                            <option value="conge_individuel">Congé individuel</option>
                                            <option value="conge_collectif">Congé collectif</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Date de début</label>
                                        <input type="date" class="form-control" id="edit_absence_date_debut" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Date de fin</label>
                                        <input type="date" class="form-control" id="edit_absence_date_fin" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Raison/Motif</label>
                                        <textarea class="form-control" id="edit_absence_reason" rows="3">${eventData.extendedProps.absence_reason || ''}</textarea>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Statut</label>
                                        <select class="form-control" id="edit_absence_statut">
                                            <option value="pending">En attente</option>
                                            <option value="approved">Approuvé</option>
                                            <option value="rejected">Rejeté</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger" id="deleteAbsenceBtn">Supprimer</button>
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                                    <button type="submit" class="btn btn-primary">Mettre à jour</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            `;
            
            $('#editAbsenceModal').remove();
            $('body').append(formHtml);
            
            // Set the correct employee and type after modal is added
            setTimeout(() => {
                $('#edit_absence_employee_id').val(eventData.extendedProps.employee_id || eventData.getResources()[0]?.id);
                $('#edit_absence_type').val(eventData.extendedProps.absence_type);
                
                // Fix date calculation - don't subtract day for display
                const startDate = new Date(eventData.start);
                const endDate = new Date(eventData.end);
                startDate.setDate(startDate.getDate() + 1);
                
                $('#edit_absence_date_debut').val(startDate.toISOString().split('T')[0]);
                $('#edit_absence_date_fin').val(endDate.toISOString().split('T')[0]);

                $('#edit_absence_statut').val(eventData.extendedProps.absence_statut);


                // $('#edit_absence_reason').val(eventData.extendedProps.absence_reason);
            }, 100);
            
            $('#editAbsenceModal').modal('show');

            setTimeout(() => {
                $('#edit_absence_employee_id').val(eventData.extendedProps.employee_id || eventData.getResources()[0]?.id);
                $('#edit_absence_type').val(eventData.extendedProps.absence_type);
                $('#edit_absence_statut').val(eventData.extendedProps.absence_statut);
                
                const startDate = new Date(eventData.start);
                const endDate = new Date(eventData.end);
                startDate.setDate(startDate.getDate() + 1);
                endDate.setDate(endDate.getDate() /*- 1*/);
                
                $('#edit_absence_date_debut').val(startDate.toISOString().split('T')[0]);
                $('#edit_absence_date_fin').val(endDate.toISOString().split('T')[0]);
                
                // Set initial min value
                $('#edit_absence_date_fin').attr('min', startDate.toISOString().split('T')[0]);
            }, 100);
            
            // Add date validation
            $('#edit_absence_date_debut').on('change', function() {
                const startDate = this.value;
                const endDateInput = $('#edit_absence_date_fin');
                
                endDateInput.attr('min', startDate);
                
                if (endDateInput.val() && endDateInput.val() < startDate) {
                    endDateInput.val(startDate);
                }
            });
            
            $('#edit_absence_date_fin').on('change', function() {
                const endDate = this.value;
                const startDate = $('#edit_absence_date_debut').val();
                
                if (startDate && endDate < startDate) {
                    this.setCustomValidity('La date de fin doit être après la date de début');
                    this.reportValidity();
                    return false;
                } else {
                    this.setCustomValidity('');
                }
            });
            
            $('#editAbsenceForm').submit(function(e) {
                e.preventDefault();
                updateAbsence(eventData);
            });
            
            $('#deleteAbsenceBtn').click(function() {
                deleteAbsence(eventData);
            });
            
            $('#editAbsenceModal').on('hidden.bs.modal', function() {
                $(this).remove();
            });
        }

        function handleAbsenceDuplicate(originalEvent) {
            const duplicateStartDate = new Date(originalEvent.start);
            const duplicateEndDate = new Date(originalEvent.end);
            duplicateEndDate.setDate(duplicateEndDate.getDate() - 1); // Adjust for storage
            
            const duplicateData = {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                employee_id: originalEvent.extendedProps.employee_id || originalEvent.getResources()[0]?.id,
                type: originalEvent.extendedProps.absence_type,
                date_debut: formatDateForServer(duplicateStartDate),
                date_fin: formatDateForServer(duplicateEndDate),
                reason: originalEvent.extendedProps.reason
            };
            
            fetch('<?php echo e(route("admin.store-absence-timeline")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': duplicateData._token
                },
                body: JSON.stringify(duplicateData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const newAbsenceEvent = {
                        id: 'absence-' + data.absence.id,
                        resourceId: data.absence.employee_id.toString(),
                        title: getAbsenceTitleForCalendar(data.absence) + ' (Copie)',
                        start: data.absence.date_debut,
                        end: new Date(new Date(data.absence.date_fin).setDate(new Date(data.absence.date_fin).getDate() + 1)).toISOString().split('T')[0],
                        allDay: true,
                        backgroundColor: getAbsenceColorForCalendar(data.absence.type),
                        borderColor: getAbsenceColorForCalendar(data.absence.type),
                        classNames: ['absence-event'],
                        extendedProps: {
                            type: 'absence',
                            absence_id: data.absence.id,
                            absence_type: data.absence.type,
                            statut: data.absence.statut,
                            reason: data.absence.reason,
                            employee_id: data.absence.employee_id,
                            editable: true
                        }
                    };
                    
                    globalCalendar.addEvent(newAbsenceEvent);
                    
                    Toastify({
                        text: 'Absence dupliquée avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                }
            })
            .catch(error => {
                Toastify({
                    text: 'Erreur lors de la duplication: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function handleAbsenceMove(info) {
            const event = info.event;
            const startDate = new Date(event.start);
            const endDate = new Date(event.end);
            const storageEndDate = new Date(endDate.getTime() - 24 * 60 * 60 * 1000);
            
            const moveData = {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                absence_id: event.extendedProps.absence_id,
                new_start_date: formatDateForServer(startDate),
                new_end_date: formatDateForServer(storageEndDate),
                new_employee_id: event.getResources()[0]?.id
            };
            
            fetch('<?php echo e(route("admin.move-absence")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': moveData._token
                },
                body: JSON.stringify(moveData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Toastify({
                        text: 'Absence déplacée avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                } else {
                    throw new Error(data.message);
                }
            })
            .catch(error => {
                info.revert();
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function handleAbsenceResize(info) {
            const event = info.event;
            const startDate = new Date(event.start);
            const endDate = new Date(event.end);
            const storageEndDate = new Date(endDate.getTime() - 24 * 60 * 60 * 1000);
            
            const resizeData = {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                absence_id: event.extendedProps.absence_id,
                date_debut: formatDateForServer(startDate),
                date_fin: formatDateForServer(storageEndDate)
            };
            
            fetch('<?php echo e(route("admin.resize-absence")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': resizeData._token
                },
                body: JSON.stringify(resizeData)
            })
            .then(response => {
                if (!response.ok) {
                    return response.text().then(text => {
                        throw new Error(`HTTP ${response.status}: ${text}`);
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    Toastify({
                        text: 'Durée modifiée avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                } else {
                    throw new Error(data.message);
                }
            })
            .catch(error => {
                console.error('Resize error:', error);
                info.revert();
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function updateAbsence(originalEvent) {
            const updateData = {
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                absence_id: $('#edit_absence_id').val(),
                employee_id: $('#edit_absence_employee_id').val(),
                type: $('#edit_absence_type').val(),
                statut: $('#edit_absence_statut').val(),
                date_debut: $('#edit_absence_date_debut').val(),
                date_fin: $('#edit_absence_date_fin').val(),
                reason: $('#edit_absence_reason').val()
            };
            
            fetch('<?php echo e(route("admin.update-absence-timeline")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': updateData._token
                },
                body: JSON.stringify(updateData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update event on calendar
                    originalEvent.setProp('title', getAbsenceTitleFromType(updateData.type));
                    originalEvent.setProp('backgroundColor', getAbsenceColorForCalendar(updateData.type));
                    originalEvent.setProp('borderColor', getAbsenceColorForCalendar(updateData.type));
                    originalEvent.setStart(updateData.date_debut);
                    originalEvent.setEnd(new Date(new Date(updateData.date_fin).setDate(new Date(updateData.date_fin).getDate() + 1)));
                    originalEvent.setProp('resourceId', updateData.employee_id);
                    
                    Toastify({
                        text: 'Absence mise à jour avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                    
                    $('#editAbsenceModal').modal('hide');
                }
            })
            .catch(error => {
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function deleteAbsence(eventData) {
            if (!confirm('Êtes-vous sûr de vouloir supprimer cette absence?')) return;
            
            fetch('<?php echo e(route("admin.delete-absence-timeline")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    absence_id: eventData.extendedProps.absence_id
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    eventData.remove();
                    
                    Toastify({
                        text: 'Absence supprimée avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                    
                    $('#editAbsenceModal').modal('hide');
                }
            })
            .catch(error => {
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            });
        }

        function getAbsenceTitleFromType(type) {
            const titles = {
                'absence': 'Autre',
                'conge_individuel': 'Congé individuel',
                'conge_collectif': 'Congé collectif'
            };
            return titles[type] || 'Autre';
        }


        function createRegularEvent(info, employeeName, metier, resourceId) {
            // Your existing event creation logic
            document.getElementById('sidebarTitle').textContent = `Ajouter un événement à ${employeeName}${metier ? ` (${metier})` : ''}`;
            document.getElementById('employee_id').value = resourceId;
            
            const startDate = new Date(info.start);
            const endDate = new Date(info.end);
            startDate.setDate(startDate.getDate() + 1);
            
            $('#event_start_date').val(startDate.toISOString().split('T')[0]);
            $('#event_end_date').val(endDate.toISOString().split('T')[0]);
            $('#new_chantier_date_debut').val(startDate.toISOString().split('T')[0]);
            $('#new_chantier_date_fin').val(endDate.toISOString().split('T')[0]);
            $('.tache-date-debut').val(startDate.toISOString().split('T')[0]);
            $('.tache-date-fin').val(endDate.toISOString().split('T')[0]);
            
            $('#employeeEventForm').data('employee_id', resourceId);
            $('#event_name').val('');
            $('#event_note').val('');
            
            initColorPicker();
            openSidebar('add');
        }

        function showAbsenceForm(info, employeeName, type, resourceId) {
            const typeLabels = {
                'absence': 'Autre',
                'conge_individuel': 'Congé individuel',
                'conge_collectif': 'Congé collectif',
            };
            
            const formHtml = `
                <div class="modal fade" id="absenceModal" tabindex="-1" role="dialog">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Ajouter ${typeLabels[type]} - ${employeeName}</h5>
                                <button type="button" class="close" data-dismiss="modal">
                                    <span>&times;</span>
                                </button>
                            </div>
                            <form id="absenceForm">
                                <div class="modal-body">
                                    <input type="hidden" id="absence_employee_id" value="${resourceId}">
                                    <input type="hidden" id="absence_type" value="${type}">
                                    
                                    <div class="form-group">
                                        <label>Date de début</label>
                                        <input type="date" class="form-control" id="absence_date_debut" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Date de fin</label>
                                        <input type="date" class="form-control" id="absence_date_fin" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Raison/Motif</label>
                                        <textarea class="form-control" id="absence_reason" rows="3"></textarea>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label>Statut</label>
                                        <select class="form-control" id="absence_statut">
                                            <option value="pending">En attente</option>
                                            <option value="approved">Approuvé</option>
                                            <option value="rejected">Refusé</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                                    <button type="submit" class="btn btn-primary">Créer ${typeLabels[type]}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            `;
            
            $('#absenceModal').remove();
            $('body').append(formHtml);
            
            const startDate = new Date(info.start);
            const endDate = new Date(info.end);
            startDate.setDate(startDate.getDate() + 1);
            
            $('#absence_date_debut').val(startDate.toISOString().split('T')[0]);
            $('#absence_date_fin').val(endDate.toISOString().split('T')[0]);
            
            $('#absenceModal').modal('show');

            // Add date validation
            $('#absence_date_debut').on('change', function() {
                const startDate = this.value;
                const endDateInput = $('#absence_date_fin');
                
                // Set minimum end date to start date
                endDateInput.attr('min', startDate);
                
                // If end date is before start date, update it
                if (endDateInput.val() && endDateInput.val() < startDate) {
                    endDateInput.val(startDate);
                }
            });
            
            $('#absence_date_fin').on('change', function() {
                const endDate = this.value;
                const startDate = $('#absence_date_debut').val();
                
                if (startDate && endDate < startDate) {
                    this.setCustomValidity('La date de fin doit être après la date de début');
                    this.reportValidity();
                    return false;
                } else {
                    this.setCustomValidity('');
                }
            });
            
            $('#absenceForm').submit(function(e) {
                e.preventDefault();
                saveAbsence();
            });
            
            $('#absenceModal').on('hidden.bs.modal', function() {
                $(this).remove();
            });
        }

        function saveAbsence() {
            const formData = {
                employee_id: $('#absence_employee_id').val(),
                type: $('#absence_type').val(),
                date_debut: $('#absence_date_debut').val(),
                date_fin: $('#absence_date_fin').val(),
                category: $('#absence_category').val(),
                reason: $('#absence_reason').val(),
                status: $('#absence_statut').val(),
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            };
            
            const submitBtn = $('#absenceForm button[type="submit"]');
            const originalText = submitBtn.text();
            submitBtn.prop('disabled', true).text('Création...');
            
            fetch('<?php echo e(route("admin.store-absence-timeline")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': formData._token
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Add event to calendar
                    const newAbsenceEvent = {
                        id: 'absence-' + data.absence.id,
                        resourceId: data.absence.employee_id.toString(),
                        title: getAbsenceTitleForCalendar(data.absence),
                        start: data.absence.date_debut,
                        end: new Date(new Date(data.absence.date_fin).setDate(new Date(data.absence.date_fin).getDate() + 1)).toISOString().split('T')[0],
                        allDay: true,
                        backgroundColor: getAbsenceColorForCalendar(data.absence.type),
                        borderColor: getAbsenceColorForCalendar(data.absence.type),
                        classNames: ['absence-event'],
                        extendedProps: {
                            type: 'absence',
                            absence_id: data.absence.id,
                            absence_type: data.absence.type,
                            statut: data.absence.statut,
                            category: data.absence.category,
                            reason: data.absence.reason,
                            editable: true
                        }
                    };
                    
                    globalCalendar.addEvent(newAbsenceEvent);
                    
                    Toastify({
                        text: 'Absence créée avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();
                    
                    $('#absenceModal').modal('hide');
                }
            })
            .catch(error => {
                Toastify({
                    text: 'Erreur: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            })
            .finally(() => {
                submitBtn.prop('disabled', false).text(originalText);
            });
        }

        function getAbsenceTitleForCalendar(absence) {
            const titles = {
                'absence': 'Absence',
                'conge_individuel': 'Congé individuel',
                'conge_collectif': 'Congé collectif'
            };
            
            let title = titles[absence.type] || 'Absence';
            if (absence.category) {
                title += ' - ' + absence.category;
            }
            
            return title;
        }

        function getAbsenceColorForCalendar(type) {
            return {
                'absence': '#607d8b',
                'conge_individuel': '#4caf50',
                'conge_collectif': '#ff9800'
            }[type] || '#607d8b';
        }

        // Function to show event details sidebar
        function populateEditModal(eventData) {
            // Basic event info
            document.getElementById('edit-event-id').value = eventData.id;

            // Set the employee value
            const employeeSelect = document.getElementById('edit-employee');
            if (eventData.extendedProps.employee_id) {
                employeeSelect.value = eventData.extendedProps.employee_id.toString();
            }

            const startDate = new Date(eventData.start);
            startDate.setDate(startDate.getDate() + 1);

            document.getElementById('edit-name').value = eventData.extendedProps.name || '';
            document.getElementById('edit-date-debut').value = formatDateForInput(startDate);
            document.getElementById('edit-date-fin').value = formatDateForInput(eventData.end);
            document.getElementById('edit-note').value = eventData.extendedProps.note || '';
            document.getElementById('edit-event-color').value = eventData.backgroundColor || '#52357B';

            // Initialize color picker
            setTimeout(() => {
                initEditColorPicker();
                // Select the color in the palette if it exists
                if (eventData.backgroundColor) {
                    setTimeout(() => {
                        const color = eventData.backgroundColor;
                        const colorEl = document.querySelector(`#edit-colorOptions .color-option[data-color="${color}"]`);
                        if (colorEl) {
                            colorEl.click();
                        } else {
                            // If color not in palette, update custom color
                            const customColorPicker = document.getElementById('edit-customColorPicker');
                            if (customColorPicker) {
                                customColorPicker.value = color;
                                document.getElementById('edit-selectedColorPreview').style.backgroundColor = color;
                            }
                        }
                    }, 100);
                }
            }, 100);

            document.getElementById('edit-chantier-date_de_debut').value = eventData.extendedProps.chantier_date_de_debut || '';
            document.getElementById('edit-chantier-date_de_fin').value = eventData.extendedProps.chantier_date_de_fin || '';

            // Set the chantier value and initialize Select2
            const chantierSelect = $('#edit-chantier');

            // Completely remove old event handlers first
            chantierSelect.off('change select2:select select2:clear');

            // Destroy existing Select2 instance if it exists
            if (chantierSelect.hasClass('select2-hidden-accessible')) {
                chantierSelect.select2('destroy');
            }

            // Clear and reset the select element
            chantierSelect.val('').trigger('change');

            // Set the value if exists
            if (eventData.extendedProps.chantier_id) {
                chantierSelect.val(eventData.extendedProps.chantier_id.toString());
            }

            // Reinitialize Select2
            chantierSelect.select2({
                width: '100%',
                placeholder: 'Sélectionner un chantier',
                allowClear: true,
                dropdownParent: $('#editTimelineSidebar') // Important: bind to sidebar
            });

            // Attach change event using both 'change' and 'select2:select'
            chantierSelect.on('change', function() {
                const chantierId = $(this).val();
                if (chantierId) {
                    const selectedText = $(this).find('option:selected').text();
                    $('#edit-name').val(selectedText);
                    console.log('Changed to:', selectedText);
                }
            });

            chantierSelect.on('select2:select', function(e) {
                const chantierName = e.params.data.text;
                $('#edit-name').val(chantierName);
                console.log('Select2 selected:', chantierName);
            });

            // Handle when cleared
            chantierSelect.on('select2:clear', function() {
                $('#edit-name').val('');
            });

            // Taches
            const tachesList = document.getElementById('edit-taches-list');
            if (eventData.extendedProps.taches_details && eventData.extendedProps.taches_details.length > 0) {
                let tachesHtml = '<ul class="list-unstyled">';
                eventData.extendedProps.taches_details.forEach(tache => {
                    tachesHtml += `
                        <li class="mb-2">
                            <strong>${tache.nom}</strong><br>
                            <small class="text-muted">${tache.description || 'Pas de description'}</small><br>
                            <small>Du ${formatDate(tache.date_debut)} au ${formatDate(tache.date_fin)} (${tache.nb_jours} jours)</small>
                            ${getStatusBadgeHtml(tache.status)}
                        </li>
                    `;
                });
                tachesHtml += '</ul>';
                tachesList.innerHTML = tachesHtml;
            } else {
                tachesList.innerHTML = '<p class="text-muted">Aucune tâche associée</p>';
            }

            if (eventData.extendedProps.taches_details && eventData.extendedProps.taches_details.length > 0) {
                loadTachesForEdit(eventData.extendedProps.taches_details);
            } else {
                document.getElementById('edit-taches-container').innerHTML = '';
            }
            
            // Show the sidebar
            openSidebar('edit');
        }

        $('#updateEmployeeEvent').click(function() {
            const eventId = $('#edit-event-id').val();
            if (!eventId) {
                Toastify({
                    text: 'ID de l\'événement manquant!',
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
                return;
            }

            const formData = new FormData();
            formData.append('_token', '<?php echo e(csrf_token()); ?>');
            formData.append('_method', 'POST');
            formData.append('event_id', eventId);
            formData.append('event_name', $('#edit-name').val());
            formData.append('event_start_date', $('#edit-date-debut').val());
            formData.append('event_end_date', $('#edit-date-fin').val());
            formData.append('event_note', $('#edit-note').val());
            formData.append('event_color', $('#edit-event-color').val());
            formData.append('employee_id', $('#edit-employee').val());
            formData.append('edit-chantier', $('#edit-chantier').val());
            formData.append('edit-chantier-date_de_debut', $('#edit-chantier-date_de_debut').val());
            formData.append('edit-chantier-date_de_fin', $('#edit-chantier-date_de_fin').val());

            const taches = [];
            document.querySelectorAll('#edit-taches-container .tache-item').forEach(tacheEl => {
                taches.push({
                    id: tacheEl.dataset.tacheId.startsWith('new-') ? null : tacheEl.dataset.tacheId,
                    nom: tacheEl.querySelector('.tache-nom').value,
                    description: tacheEl.querySelector('.tache-description').value,
                    date_debut: tacheEl.querySelector('.tache-date-debut').value,
                    date_fin: tacheEl.querySelector('.tache-date-fin').value,
                    status: tacheEl.querySelector('.tache-status').value,
                    _destroy: false
                });
            });
            formData.append('taches', JSON.stringify(taches));

            const updateBtn = $(this);
            const originalBtnText = updateBtn.html();
            updateBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Mise à jour...');

            // Get original color and chantier_id to detect changes
            const currentEvent = globalCalendar.getEventById(eventId);
            const originalColor = currentEvent ? currentEvent.backgroundColor : null;
            const originalChantierName = currentEvent ? currentEvent.extendedProps.chantier_nom : null;
            const newColor = $('#edit-event-color').val();
            const newChantierSelect = document.getElementById('edit-chantier');
            const newChantierName = newChantierSelect.options[newChantierSelect.selectedIndex]?.text || '';

            $.ajax({
                url: '<?php echo e(route("admin.update-event-employee")); ?>',
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    Toastify({
                        text: 'Événement mis à jour avec succès!',
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#4CAF50"
                    }).showToast();

                    // UPDATE EVENT LIVE ON CALENDAR - NO RELOAD
                    const existingEvent = globalCalendar.getEventById(eventId);
                    if (existingEvent) {
                        const chantierSelect = document.getElementById('edit-chantier');
                        const chantierName = chantierSelect.options[chantierSelect.selectedIndex]?.text || '';
                        
                        const updatedEventData = {
                            title: $('#edit-name').val() + (chantierName ? ' - ' + chantierName : ''),
                            start: $('#edit-date-debut').val(),
                            end: new Date(new Date($('#edit-date-fin').val()).setDate(new Date($('#edit-date-fin').val()).getDate() + 1)).toISOString().split('T')[0],
                            backgroundColor: $('#edit-event-color').val(),
                            borderColor: $('#edit-event-color').val(),
                            resourceId: $('#edit-employee').val()
                        };

                        existingEvent.setExtendedProp('name', $('#edit-name').val());
                        existingEvent.setExtendedProp('note', $('#edit-note').val());
                        existingEvent.setExtendedProp('date_debut', $('#edit-date-debut').val());
                        existingEvent.setExtendedProp('date_fin', $('#edit-date-fin').val());
                        existingEvent.setExtendedProp('chantier_id', $('#edit-chantier').val());
                        existingEvent.setExtendedProp('chantier_nom', chantierName);
                        existingEvent.setExtendedProp('employee_id', $('#edit-employee').val());

                        existingEvent.setProp('title', updatedEventData.title);
                        existingEvent.setStart(updatedEventData.start);
                        existingEvent.setEnd(updatedEventData.end);
                        existingEvent.setProp('backgroundColor', updatedEventData.backgroundColor);
                        existingEvent.setProp('borderColor', updatedEventData.borderColor);
                        existingEvent.setProp('resourceId', updatedEventData.resourceId);

                        // LIVE COLOR SYNC FOR CHANTIER EVENTS
                        const updatedChantierIdStr = $('#edit-chantier').val();
                        
                        // Only sync colors if:
                        // 1. Event has a chantier associated
                        // 2. The color actually changed
                        // 3. We have a valid chantier ID
                        if (updatedChantierIdStr && newColor && newColor !== originalColor) {
                            console.log('Color changed from', originalColor, 'to', newColor, 'for chantier', updatedChantierIdStr);
                            
                            // Find and update all other events for this chantier
                            const allEvents = globalCalendar.getEvents();
                            let updatedCount = 0;
                            
                            allEvents.forEach(event => {
                                if (event.extendedProps.chantier_id && 
                                    event.extendedProps.chantier_id.toString() === updatedChantierIdStr &&
                                    event.id !== eventId) {
                                    
                                    // Update the event's color properties
                                    event.setProp('backgroundColor', newColor);
                                    event.setProp('borderColor', newColor);
                                    updatedCount++;
                                }
                            });
                            
                            console.log(`Live updated ${updatedCount} related events to color: ${newColor}`);
                            
                            if (updatedCount > 0) {
                                Toastify({
                                    text: `Couleur mise à jour pour ${updatedCount + 1} événements du chantier`,
                                    duration: 3000,
                                    close: true,
                                    gravity: "top",
                                    position: 'right',
                                    backgroundColor: "#2196F3"
                                }).showToast();
                            }
                        }
                    }

                    closeSidebar('edit');
                },
                error: function(xhr) {
                    console.error('Error updating event:', xhr);
                    const errorMsg = xhr.responseJSON?.message || 'Une erreur est survenue lors de la mise à jour de l\'événement';
                    Toastify({
                        text: errorMsg,
                        duration: 3000,
                        close: true,
                        gravity: "top",
                        position: 'right',
                        backgroundColor: "#FF4D4D"
                    }).showToast();
                },
                complete: function() {
                    updateBtn.html(originalBtnText).prop('disabled', false);
                }
            });
        });

        // Updated Delete Event function
        $('#deleteEventBtn').click(function(e) {
            e.preventDefault();
            
            const eventId = $('#edit-event-id').val();
            
            if (!eventId) {
                Toastify({
                    text: 'ID de l\'événement manquant!',
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
                return;
            }
            
            if (confirm('Êtes-vous sûr de vouloir supprimer cet événement et toutes ses tâches associées ?')) {
                const deleteBtn = $(this);
                const originalHtml = deleteBtn.html();
                deleteBtn.html('<i class="fas fa-spinner fa-spin"></i> Suppression...').prop('disabled', true);
                
                $.ajax({
                    url: '<?php echo e(route("admin.delete-event-employee")); ?>',
                    method: 'POST',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        event_id: eventId
                    },
                    success: function(response) {
                        Toastify({
                            text: 'Événement supprimé avec succès!',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#4CAF50"
                        }).showToast();
                        
                        // REMOVE EVENT LIVE FROM CALENDAR - NO RELOAD
                        const event = globalCalendar.getEventById(eventId); // Use globalCalendar
                        if (event) {
                            event.remove();
                        }
                        
                        closeSidebar('edit');
                    },
                    error: function(xhr) {
                        console.error('Error deleting event:', xhr);
                        Toastify({
                            text: 'Une erreur est survenue lors de la suppression de l\'événement',
                            duration: 3000,
                            close: true,
                            gravity: "top",
                            position: 'right',
                            backgroundColor: "#FF4D4D"
                        }).showToast();
                    },
                    complete: function() {
                        deleteBtn.html(originalHtml).prop('disabled', false);
                    }
                });
            }
        });

        // Helper functions
        function formatDate(dateString) {
            return new Date(dateString).toLocaleDateString('fr-FR');
        }
        
        function getStatusBadgeHtml(status) {
            if (status === 'pending') {
                return `<span class="badge badge-warning text-white"><i class="fa-solid fa-hourglass-half"></i> En Attente</span>`;
            } else if (status === 'in_progress') {
                return `<span class="badge badge-info text-white"><i class="fa-solid fa-bars-progress"></i> En Cours</span>`;
            } else if (status === 'completed') {
                return `<span class="badge badge-success text-white"><i class="fa-solid fa-circle-check"></i> Complété</span>`;
            }
            return `<span class="badge badge-secondary">Aucun statut</span>`;
        }
    });


    function handleEventMove(info) {
        const event = info.event;
        const oldResource = info.oldResource;
        const newResource = info.newResource;
        
        console.log('Event move details:', {
            eventId: event.id,
            oldStart: event.start,
            newStart: info.event.start,
            oldEnd: event.end,
            newEnd: info.event.end,
            oldResource: oldResource?.id,
            newResource: newResource?.id
        });
        
        // Show loading indicator
        showEventLoadingState(event, 'Déplacement...');
        
        // FIXED DATE CALCULATION - avoid timezone issues
        const startDate = new Date(event.start);
        const endDate = new Date(event.end);
        
        // Get local date components to avoid timezone conversion
        const correctStartDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate());
        const correctEndDate = new Date(endDate.getFullYear(), endDate.getMonth(), endDate.getDate());
        
        // For storage, subtract 1 day from end (FullCalendar uses exclusive end dates)
        const storageEndDate = new Date(correctEndDate);
        storageEndDate.setDate(storageEndDate.getDate() - 1);
        
        // Prepare data for server
        const moveData = {
            _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            event_id: event.id,
            new_start_date: formatDateForServer(correctStartDate),
            new_end_date: formatDateForServer(storageEndDate),
            new_employee_id: newResource ? newResource.id : (event.getResources()[0] ? event.getResources()[0].id : null),
            old_employee_id: oldResource ? oldResource.id : null
        };
        
        console.log('Sending move data:', moveData);
        
        // Send AJAX request
        fetch('<?php echo e(route("admin.move-event-employee")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(moveData)
        })
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => {
                    throw new Error(`HTTP ${response.status}: ${text}`);
                });
            }
            return response.json();
        })
        .then(data => {
            console.log('Move response:', data);
            if (data.success) {
                // Update extended props
                event.setExtendedProp('employee_id', moveData.new_employee_id);
                event.setExtendedProp('date_debut', moveData.new_start_date);
                event.setExtendedProp('date_fin', moveData.new_end_date);
                
                Toastify({
                    text: 'Événement déplacé avec succès!',
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#4CAF50"
                }).showToast();
            } else {
                throw new Error(data.message || 'Erreur lors du déplacement');
            }
        })
        .catch(error => {
            console.error('Error moving event:', error);
            
            // Revert the event position
            info.revert();
            
            Toastify({
                text: 'Erreur lors du déplacement: ' + error.message,
                duration: 5000,
                close: true,
                gravity: "top",
                position: 'right',
                backgroundColor: "#FF4D4D"
            }).showToast();
        })
        .finally(() => {
            hideEventLoadingState(event);
        });
    }

    // Handle event resize
    function handleEventResize(info) {
        const event = info.event;
        
        console.log('Event resize details:', {
            eventId: event.id,
            newStart: event.start,
            newEnd: event.end
        });
        
        // Show loading indicator
        showEventLoadingState(event, 'Redimensionnement...');
        
        // SAME DATE FIX as move function
        const startDate = new Date(event.start);
        const endDate = new Date(event.end);
        
        const correctStartDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate());
        const correctEndDate = new Date(endDate.getFullYear(), endDate.getMonth(), endDate.getDate());
        const storageEndDate = new Date(correctEndDate);
        storageEndDate.setDate(storageEndDate.getDate() - 1);
        
        // Prepare data for server
        const resizeData = {
            _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            event_id: event.id,
            new_start_date: formatDateForServer(correctStartDate),
            new_end_date: formatDateForServer(storageEndDate)
        };
        
        console.log('Sending resize data:', resizeData);
        
        // Send AJAX request
        fetch('<?php echo e(route("admin.resize-event-employee")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(resizeData)
        })
        .then(response => {
            if (!response.ok) {
                return response.text().then(text => {
                    throw new Error(`HTTP ${response.status}: ${text}`);
                });
            }
            return response.json();
        })
        .then(data => {
            console.log('Resize response:', data);
            if (data.success) {
                // Update extended props
                event.setExtendedProp('date_debut', resizeData.new_start_date);
                event.setExtendedProp('date_fin', resizeData.new_end_date);
                
                Toastify({
                    text: 'Durée de l\'événement modifiée avec succès!',
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#4CAF50"
                }).showToast();
            } else {
                throw new Error(data.message || 'Erreur lors du redimensionnement');
            }
        })
        .catch(error => {
            console.error('Error resizing event:', error);
            
            // Revert the event size
            info.revert();
            
            Toastify({
                text: 'Erreur lors du redimensionnement: ' + error.message,
                duration: 5000,
                close: true,
                gravity: "top",
                position: 'right',
                backgroundColor: "#FF4D4D"
            }).showToast();
        })
        .finally(() => {
            hideEventLoadingState(event);
        });
    }

    // Handle event duplication (Ctrl+Click)
    function handleEventDuplicate(event) {
        console.log('Duplicating event - Original dates:', {
            start: event.start,
            end: event.end,
            startDay: event.start.getDay(),
            endDay: event.end ? event.end.getDay() : 'null'
        });
        
        // FOR SAME POSITION DUPLICATION (recommended for testing first)
        // Use exact same dates as original
        const duplicateStartDate = new Date(event.start);
        const duplicateEndDate = new Date(event.end);
        
        // Adjust end date for storage (FullCalendar uses exclusive end dates)
        const storageEndDate = new Date(duplicateEndDate.getTime() - 24 * 60 * 60 * 1000);
        
        // FOR DIFFERENT POSITION DUPLICATION (uncomment to test)
        // Move to next week:
        // duplicateStartDate.setDate(duplicateStartDate.getDate() + 7);
        // storageEndDate.setDate(storageEndDate.getDate() + 7);
        
        console.log('Calculated duplicate dates:', {
            duplicateStart: duplicateStartDate,
            storageEnd: storageEndDate,
            formattedStart: formatDateForServer(duplicateStartDate),
            formattedEnd: formatDateForServer(storageEndDate)
        });
        
        const duplicateData = {
            _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            original_event_id: event.id,
            duplicate_start_date: formatDateForServer(duplicateStartDate),
            duplicate_end_date: formatDateForServer(storageEndDate),
            duplicate_employee_id: event.getResources()[0]?.id || event.extendedProps.employee_id
        };
        
        console.log('Sending duplicate request:', duplicateData);
        
        Toastify({
            text: 'Duplication en cours...',
            duration: 2000,
            close: true,
            gravity: "top",
            position: 'right',
            backgroundColor: "#2196F3"
        }).showToast();
        
        fetch('<?php echo e(route("admin.duplicate-event-employee")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(duplicateData)
        })
        .then(response => {
            console.log('Duplicate response status:', response.status);
            if (!response.ok) {
                return response.text().then(text => {
                    throw new Error(`HTTP ${response.status}: ${text}`);
                });
            }
            return response.json();
        })
        .then(data => {
            console.log('Duplicate success response:', data);
            if (data.success) {
                // Calculate display end date for FullCalendar (add 1 day)
                const displayEndDate = new Date(data.event.date_fin);
                displayEndDate.setDate(displayEndDate.getDate() + 1);
                
                const duplicatedEvent = {
                    id: data.event.id.toString(),
                    resourceId: data.event.employee_id.toString(),
                    title: data.event.name + (data.chantier?.nom ? ' - ' + data.chantier.nom : '') + ' (Copie)',
                    start: data.event.date_debut,
                    end: displayEndDate.toISOString().split('T')[0],
                    allDay: true,
                    backgroundColor: data.event.event_color || '#3788d8',
                    borderColor: data.event.event_color || '#3788d8',
                    extendedProps: {
                        event_id: data.event.id,
                        chantier_id: data.chantier?.id || '',
                        chantier_nom: data.chantier?.nom || '',
                        chantier_date_de_debut: data.chantier?.date_de_debut || '',
                        chantier_date_de_fin: data.chantier?.date_de_fin || '',
                        chantier_nbjours: data.chantier?.nb_jours || '',
                        taches_ids: data.event.taches_id ? JSON.parse(data.event.taches_id) : [],
                        taches_details: data.taches_details || [],
                        employee_id: data.event.employee_id,
                        employee_nom: data.event.employee?.name + ' ' + data.event.employee?.prenom || '',
                        name: data.event.name,
                        note: data.event.note,
                        status: data.event.status,
                        date_debut: data.event.date_debut,
                        date_fin: data.event.date_fin,
                        created_at: data.event.created_at,
                        updated_at: data.event.updated_at
                    }
                };
                
                console.log('Adding event to calendar:', duplicatedEvent);
                globalCalendar.addEvent(duplicatedEvent);
                
                Toastify({
                    text: 'Événement dupliqué avec succès!',
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#4CAF50"
                }).showToast();
            } else {
                throw new Error(data.message || 'Erreur lors de la duplication');
            }
        })
        .catch(error => {
            console.error('Duplication error:', error);
            Toastify({
                text: 'Erreur lors de la duplication: ' + error.message,
                duration: 5000,
                close: true,
                gravity: "top",
                position: 'right',
                backgroundColor: "#FF4D4D"
            }).showToast();
        });
    }

    // Helper functions
    function formatDateForServer(date) {
        if (!(date instanceof Date)) {
            date = new Date(date);
        }
        
        // Use local date components to avoid timezone issues
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        
        return `${year}-${month}-${day}`;
    }

    function showEventLoadingState(event, message) {
        // Add loading class to event element
        const eventEl = event.el;
        if (eventEl) {
            eventEl.style.opacity = '0.6';
            eventEl.style.pointerEvents = 'none';
            
            // Add loading indicator
            const loadingEl = document.createElement('div');
            loadingEl.className = 'event-loading';
            loadingEl.innerHTML = `<i class="fas fa-spinner fa-spin"></i> ${message}`;
            loadingEl.style.cssText = `
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                font-size: 10px;
                color: white;
                text-shadow: 1px 1px 1px rgba(0,0,0,0.8);
                background: rgba(0,0,0,0.5);
                padding: 2px 6px;
                border-radius: 3px;
                z-index: 10;
            `;
            eventEl.style.position = 'relative';
            eventEl.appendChild(loadingEl);
        }
    }

    function hideEventLoadingState(event) {
        const eventEl = event.el;
        if (eventEl) {
            eventEl.style.opacity = '1';
            eventEl.style.pointerEvents = 'auto';
            
            // Remove loading element
            const loadingEl = eventEl.querySelector('.event-loading');
            if (loadingEl) {
                loadingEl.remove();
            }
        }
    }
    // Debug function to help troubleshoot
    window.debugEventDates = function(event) {
        console.log('Event Debug Info:', {
            id: event.id,
            title: event.title,
            start: event.start,
            end: event.end,
            startFormatted: formatDateForServer(event.start),
            endFormatted: formatDateForServer(new Date(event.end.getTime() - 24 * 60 * 60 * 1000)),
            resourceId: event.getResources()[0]?.id,
            extendedProps: event.extendedProps
        });
    };



    // ADVANCED DUPLICATION DIALOG (Optional)
    function showDuplicateDialog(originalEvent) {
        const dialogHtml = `
            <div class="modal fade" id="duplicateModal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Dupliquer l'événement</h5>
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Nouvel employé</label>
                                <select class="form-control" id="duplicate-employee">
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?> <?php echo e($employee->prenom); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Nouvelle date de début</label>
                                <input type="date" class="form-control" id="duplicate-start-date">
                            </div>
                            <div class="form-group">
                                <label>Nouvelle date de fin</label>
                                <input type="date" class="form-control" id="duplicate-end-date">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Annuler</button>
                            <button type="button" class="btn btn-primary" id="confirm-duplicate">Dupliquer</button>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // You can implement this advanced dialog if needed
    }

    function createEventObject(eventData) {
        // Calculate end date (add 1 day for FullCalendar exclusive end)
        const endDate = new Date(eventData.date_fin);
        endDate.setDate(endDate.getDate() + 1);
        
        return {
            id: eventData.id.toString(),
            resourceId: eventData.employee_id.toString(),
            title: eventData.name + (eventData.chantier && eventData.chantier.nom ? ' - ' + eventData.chantier.nom : ''),
            start: eventData.date_debut,
            end: endDate.toISOString().split('T')[0],
            allDay: true,
            backgroundColor: eventData.event_color || '#3788d8',
            borderColor: eventData.event_color || '#3788d8',
            extendedProps: {
                event_id: eventData.id,
                chantier_id: eventData.chantier?.id || '',
                chantier_nom: eventData.chantier?.nom || '',
                chantier_date_de_debut: eventData.chantier?.date_de_debut || '',
                chantier_date_de_fin: eventData.chantier?.date_de_fin || '',
                taches_ids: eventData.taches_id ? JSON.parse(eventData.taches_id) : [],
                taches_details: eventData.taches_details || [],
                employee_id: eventData.employee_id,
                employee_nom: eventData.employee?.name + ' ' + eventData.employee?.prenom || '',
                name: eventData.name,
                note: eventData.note,
                status: eventData.status,
                date_debut: eventData.date_debut,
                date_fin: eventData.date_fin,
                created_at: eventData.created_at,
                updated_at: eventData.updated_at
            }
        };
    }

    // Additional helper functions for form reset
    function resetAddForm() {
        document.getElementById('employeeEventForm').reset();
        document.getElementById('tachesContainer').innerHTML = '';
        
        // Reset chantier type to new
        document.getElementById('newChantierBtn').classList.add('active');
        document.getElementById('existingChantierBtn').classList.remove('active');
        document.getElementById('newChantierSection').classList.remove('d-none');
        document.getElementById('existingChantierSection').classList.add('d-none');
        
        // Reset color to default
        document.getElementById('event_color').value = '#52357B';
        document.getElementById('selectedColorPreview').style.backgroundColor = '#52357B';
        
        // Reset active tab to details
        switchTab('details', 'add');
    }

    // Updated Save Employee Event function
    document.getElementById('saveEmployeeEvent').addEventListener('click', function() {
        
        const saveBtn = document.getElementById('saveEmployeeEvent');
        const originalBtnText = saveBtn.innerHTML;
        saveBtn.disabled = true;
        saveBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Enregistrement...';

        try {
            const formData = {
                event_name: document.getElementById('event_name').value,
                event_start_date: document.getElementById('event_start_date').value,
                event_end_date: document.getElementById('event_end_date').value,
                event_note: document.getElementById('event_note').value,
                event_color: document.getElementById('event_color').value,
                resource_id: document.getElementById('employeeEventForm').dataset.resourceId,
                employee_id: document.getElementById('employee_id').value,
                chantier_type: document.getElementById('newChantierBtn').classList.contains('active') ? 'new' : 'existing',
                new_chantier: {
                    nom: document.getElementById('new_chantier_nom').value,
                    adresse: document.getElementById('new_chantier_adresse').value,
                    date_debut: document.getElementById('new_chantier_date_debut').value,
                    date_fin: document.getElementById('new_chantier_date_fin').value
                },
                existing_chantier_id: document.getElementById('existing_chantier_id').value,
                taches: []
            };

            const taskItems = document.querySelectorAll('.tache-item');
            taskItems.forEach(task => {
                formData.taches.push({
                    nom: task.querySelector('.tache-nom').value,
                    description: task.querySelector('.tache-description').value,
                    date_debut: task.querySelector('.tache-date-debut').value,
                    date_fin: task.querySelector('.tache-date-fin').value,
                    status: task.querySelector('.tache-status').value
                });
            });

            fetch('<?php echo e(route("admin.store-select-event-employee")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json'
                },
                body: JSON.stringify(formData)
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(err => {
                        throw new Error(err.message || 'Server error');
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
        Toastify({
            text: 'Événement enregistré avec succès!',
            duration: 3000,
            close: true,
            gravity: "top",
            position: 'right',
            backgroundColor: "#4CAF50"
        }).showToast();
        
        // CREATE LIVE EVENT ON CALENDAR - NO RELOAD
        const newCalendarEvent = {
            id: data.event.id.toString(),
            resourceId: data.event.employee_id.toString(),
            title: data.event.name + (data.chantier && data.chantier.nom ? ' - ' + data.chantier.nom : ''),
            start: data.event.date_debut,
            end: new Date(new Date(data.event.date_fin).setDate(new Date(data.event.date_fin).getDate() + 1)).toISOString().split('T')[0],
            allDay: true,
            backgroundColor: data.event.event_color || '#3788d8',
            borderColor: data.event.event_color || '#3788d8',
            extendedProps: {
                event_id: data.event.id,
                chantier_id: data.chantier?.id || '',
                chantier_nom: data.chantier?.nom || '',
                chantier_date_de_debut: data.chantier?.date_de_debut || '',
                chantier_date_de_fin: data.chantier?.date_de_fin || '',
                employee_id: data.event.employee_id,
                name: data.event.name,
                note: data.event.note,
                status: data.event.status,
                date_debut: data.event.date_debut,
                date_fin: data.event.date_fin,
                taches_details: [],
                taches_ids: JSON.parse(data.event.taches_id || '[]')
            }
        };
        
        // Add the new event to calendar
        globalCalendar.addEvent(newCalendarEvent);
        
        // UPDATE EXISTING EVENTS' COLORS if using existing chantier
        const chantierType = document.getElementById('newChantierBtn').classList.contains('active') ? 'new' : 'existing';
        
        if (chantierType === 'existing' && data.chantier && data.chantier.id) {
            const newColor = data.event.event_color;
            const chantierIdToUpdate = data.chantier.id.toString();
            
            // Find and update all existing events for this chantier
            const allEvents = globalCalendar.getEvents();
            allEvents.forEach(event => {
                if (event.extendedProps.chantier_id && 
                    event.extendedProps.chantier_id.toString() === chantierIdToUpdate &&
                    event.id !== data.event.id.toString()) {
                    
                    // Update the event's color properties
                    event.setProp('backgroundColor', newColor);
                    event.setProp('borderColor', newColor);
                }
            });
            
            console.log(`Updated ${allEvents.filter(e => e.extendedProps.chantier_id?.toString() === chantierIdToUpdate).length} events to color: ${newColor}`);
        }
        
        // Close sidebar and reset form
        closeSidebar('add', true);
        document.getElementById('employeeEventForm').reset();
        document.getElementById('tachesContainer').innerHTML = '';
    } else {
        throw new Error(data.message || 'Une erreur est survenue');
    }
            })
            .catch(error => {
                console.error('Error:', error);
                Toastify({
                    text: 'Erreur lors de l\'enregistrement: ' + error.message,
                    duration: 3000,
                    close: true,
                    gravity: "top",
                    position: 'right',
                    backgroundColor: "#FF4D4D"
                }).showToast();
            })
            .finally(() => {
                saveBtn.disabled = false;
                saveBtn.innerHTML = originalBtnText;
            });

        } catch (error) {
            console.error('Form processing error:', error);
            Toastify({
                text: 'Erreur lors du traitement du formulaire',
                duration: 3000,
                close: true,
                gravity: "top",
                position: 'right',
                backgroundColor: "#FF4D4D"
            }).showToast();
            saveBtn.disabled = false;
            saveBtn.innerHTML = originalBtnText;
        }
    });

    // DATE VALIDATION FUNCTIONS
    document.addEventListener('DOMContentLoaded', function() {
        
        // Event dates validation (Details tab)
        const eventStartDate = document.getElementById('event_start_date');
        const eventEndDate = document.getElementById('event_end_date');
        
        function validateEventDates() {
            if (eventStartDate.value && eventEndDate.value) {
                if (eventStartDate.value > eventEndDate.value) {
                    eventEndDate.setCustomValidity('La date de fin doit être après la date de début');
                    eventEndDate.reportValidity();
                    return false;
                } else {
                    eventEndDate.setCustomValidity('');
                }
            }
            return true;
        }
        
        eventStartDate.addEventListener('change', function() {
            if (eventEndDate.value && this.value > eventEndDate.value) {
                eventEndDate.value = this.value;
            }
            eventEndDate.min = this.value;
            validateEventDates();
        });
        
        eventEndDate.addEventListener('change', validateEventDates);
        
        // New Chantier dates validation
        const newChantierStartDate = document.getElementById('new_chantier_date_debut');
        const newChantierEndDate = document.getElementById('new_chantier_date_fin');
        
        function validateNewChantierDates() {
            if (newChantierStartDate.value && newChantierEndDate.value) {
                if (newChantierStartDate.value > newChantierEndDate.value) {
                    newChantierEndDate.setCustomValidity('La date de fin doit être après la date de début');
                    newChantierEndDate.reportValidity();
                    return false;
                } else {
                    newChantierEndDate.setCustomValidity('');
                }
            }
            return true;
        }
        
        newChantierStartDate.addEventListener('change', function() {
            if (newChantierEndDate.value && this.value > newChantierEndDate.value) {
                newChantierEndDate.value = this.value;
            }
            newChantierEndDate.min = this.value;
            validateNewChantierDates();
        });
        
        newChantierEndDate.addEventListener('change', validateNewChantierDates);
        
        // Edit Event dates validation
        const editStartDate = document.getElementById('edit-date-debut');
        const editEndDate = document.getElementById('edit-date-fin');
        
        function validateEditEventDates() {
            if (editStartDate.value && editEndDate.value) {
                if (editStartDate.value > editEndDate.value) {
                    editEndDate.setCustomValidity('La date de fin doit être après la date de début');
                    editEndDate.reportValidity();
                    return false;
                } else {
                    editEndDate.setCustomValidity('');
                }
            }
            return true;
        }
        
        editStartDate.addEventListener('change', function() {
            if (editEndDate.value && this.value > editEndDate.value) {
                editEndDate.value = this.value;
            }
            editEndDate.min = this.value;
            validateEditEventDates();
        });
        
        editEndDate.addEventListener('change', validateEditEventDates);
        
        // Edit Chantier dates validation
        const editChantierStartDate = document.getElementById('edit-chantier-date_de_debut');
        const editChantierEndDate = document.getElementById('edit-chantier-date_de_fin');
        
        function validateEditChantierDates() {
            if (editChantierStartDate.value && editChantierEndDate.value) {
                if (editChantierStartDate.value > editChantierEndDate.value) {
                    editChantierEndDate.setCustomValidity('La date de fin doit être après la date de début');
                    editChantierEndDate.reportValidity();
                    return false;
                } else {
                    editChantierEndDate.setCustomValidity('');
                }
            }
            return true;
        }
        
        editChantierStartDate.addEventListener('change', function() {
            if (editChantierEndDate.value && this.value > editChantierEndDate.value) {
                editChantierEndDate.value = this.value;
            }
            editChantierEndDate.min = this.value;
            validateEditChantierDates();
        });
        
        editChantierEndDate.addEventListener('change', validateEditChantierDates);
        
        // Task dates validation (dynamically added tasks)
        function validateTaskDates(taskElement) {
            const startDateInput = taskElement.querySelector('.tache-date-debut');
            const endDateInput = taskElement.querySelector('.tache-date-fin');
            
            if (!startDateInput || !endDateInput) return true;
            
            function validateDates() {
                if (startDateInput.value && endDateInput.value) {
                    if (startDateInput.value > endDateInput.value) {
                        endDateInput.setCustomValidity('La date de fin doit être après la date de début');
                        endDateInput.reportValidity();
                        return false;
                    } else {
                        endDateInput.setCustomValidity('');
                    }
                }
                return true;
            }
            
            startDateInput.addEventListener('change', function() {
                if (endDateInput.value && this.value > endDateInput.value) {
                    endDateInput.value = this.value;
                }
                endDateInput.min = this.value;
                validateDates();
            });
            
            endDateInput.addEventListener('change', validateDates);
            
            return validateDates();
        }
        
        // Apply validation to existing tasks and new tasks when added
        document.addEventListener('DOMNodeInserted', function(e) {
            if (e.target.classList && e.target.classList.contains('tache-item')) {
                validateTaskDates(e.target);
            }
        });
        
        // Initial validation for any existing tasks
        document.querySelectorAll('.tache-item').forEach(validateTaskDates);
    });


    console.log('Debug script loaded');

    // Override the duplicate function temporarily for debugging
    window.debugDuplication = function(event) {
        console.log('=== DEBUGGING DUPLICATION ===');
        
        // Original event info
        console.log('Original Event:', {
            id: event.id,
            title: event.title,
            start: event.start,
            end: event.end,
            startString: event.start.toString(),
            endString: event.end.toString()
        });
        
        // Date calculations
        const originalStartDate = new Date(event.start);
        const originalEndDate = new Date(event.end);
        const adjustedEndDate = new Date(originalEndDate.getTime() - 24 * 60 * 60 * 1000);
        
        console.log('Date Calculations:', {
            originalStart: originalStartDate,
            originalEnd: originalEndDate,
            adjustedEnd: adjustedEndDate,
            originalStartFormatted: formatDateForServer(originalStartDate),
            adjustedEndFormatted: formatDateForServer(adjustedEndDate)
        });
        
        // Test with +1 week
        const weekLaterStart = new Date(originalStartDate);
        weekLaterStart.setDate(weekLaterStart.getDate() + 7);
        const weekLaterEnd = new Date(adjustedEndDate);
        weekLaterEnd.setDate(weekLaterEnd.getDate() + 7);
        
        console.log('Week Later Calculation:', {
            weekLaterStart: weekLaterStart,
            weekLaterEnd: weekLaterEnd,
            weekLaterStartFormatted: formatDateForServer(weekLaterStart),
            weekLaterEndFormatted: formatDateForServer(weekLaterEnd)
        });
        
        // Resource info
        console.log('Resource Info:', {
            resourceId: event.getResources()[0]?.id,
            extendedPropsEmployeeId: event.extendedProps.employee_id
        });
        
        console.log('=== END DEBUG ===');
    };

    // Enhanced logging for AJAX requests
    const originalFetch = window.fetch;
    window.fetch = function(...args) {
        if (window.debugMode && args[0].includes('event-employee')) {
            console.log('🚀 AJAX Request:', args[0]);
            if (args[1] && args[1].body) {
                try {
                    const body = JSON.parse(args[1].body);
                    console.log('📦 Request Body:', body);
                } catch (e) {
                    console.log('📦 Request Body (raw):', args[1].body);
                }
            }
        }
        
        return originalFetch.apply(this, args).then(response => {
            if (window.debugMode && args[0].includes('event-employee')) {
                console.log('📥 Response Status:', response.status);
                
                // Clone response to avoid consuming it
                const clonedResponse = response.clone();
                clonedResponse.json().then(data => {
                    console.log('📥 Response Data:', data);
                }).catch(() => {
                    clonedResponse.text().then(text => {
                        console.log('📥 Response Text:', text);
                    });
                });
            }
            return response;
        });
    };

    // Alternative duplication logic for testing
    window.testDuplicateToSamePosition = function(event) {
        console.log('Testing duplication to same position...');
        
        // Calculate exact same dates
        const originalStartDate = new Date(event.start);
        const originalEndDate = new Date(event.end);
        const adjustedEndDate = new Date(originalEndDate.getTime() - 24 * 60 * 60 * 1000);
        
        const duplicateData = {
            _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            original_event_id: event.id,
            duplicate_start_date: formatDateForServer(originalStartDate),
            duplicate_end_date: formatDateForServer(adjustedEndDate),
            duplicate_employee_id: event.getResources()[0]?.id || event.extendedProps.employee_id
        };
        
        console.log('Duplicate data for same position:', duplicateData);
        
        // You can send this data to test
        return duplicateData;
    };

    // Helper function to check if routes exist
    window.checkRoutes = function() {
        console.log('=== CHECKING ROUTES ===');
        
        const routes = [
            '<?php echo e(route("admin.move-event-employee")); ?>',
            '<?php echo e(route("admin.resize-event-employee")); ?>',
            '<?php echo e(route("admin.duplicate-event-employee")); ?>'
        ];
        
        routes.forEach(route => {
            console.log('Route:', route);
            
            // Test if route responds
            fetch(route, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({}) // Empty body to test route existence
            }).then(response => {
                console.log(`Route ${route} status:`, response.status);
            }).catch(error => {
                console.log(`Route ${route} error:`, error.message);
            });
        });
    };

    window.testDragDropSetup = function() {
        console.log('=== TESTING DRAG & DROP SETUP ===');
        
        // Test if globalCalendar exists
        console.log('Global calendar exists:', typeof globalCalendar !== 'undefined');
        
        // Test if CSRF token exists
        const csrfToken = document.querySelector('meta[name="csrf-token"]');
        console.log('CSRF token exists:', csrfToken ? 'YES' : 'NO');
        if (csrfToken) {
            console.log('CSRF token value:', csrfToken.getAttribute('content'));
        }
        
        // Test if calendar has events
        if (typeof globalCalendar !== 'undefined') {
            const events = globalCalendar.getEvents();
            console.log('Calendar events count:', events.length);
            
            if (events.length > 0) {
                const firstEvent = events[0];
                console.log('First event sample:', {
                    id: firstEvent.id,
                    title: firstEvent.title,
                    start: firstEvent.start,
                    end: firstEvent.end,
                    resourceId: firstEvent.getResources()[0]?.id
                });
                
                // Test duplicate function on first event
                console.log('--- Testing duplicate function ---');
                window.debugDuplication(firstEvent);
            }
        }
        
        // Test route URLs
        console.log('Route URLs:');
        console.log('Move:', '<?php echo e(route("admin.move-event-employee")); ?>');
        console.log('Resize:', '<?php echo e(route("admin.resize-event-employee")); ?>');
        console.log('Duplicate:', '<?php echo e(route("admin.duplicate-event-employee")); ?>');
        
        console.log('=== END SETUP TEST ===');
    };

    
// Add html2canvas library
if (typeof html2canvas === 'undefined') {
    const script = document.createElement('script');
    script.src = 'https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js';
    document.head.appendChild(script);
}

function captureCalendar() {
    // Get current view type
    const currentView = globalCalendar.view.type;
    
    // Only allow capture for day and week views
    if (currentView === 'resourceTimelineMonth') {
        alert('Capture disponible uniquement pour les vues Jour et Semaine');
        return;
    }
    
    // Get period information
    const viewStart = globalCalendar.view.currentStart;
    const viewEnd = globalCalendar.view.currentEnd;
    let periodTitle = '';
    
    if (currentView === 'resourceTimelineDay') {
        periodTitle = `Jour: ${viewStart.toLocaleDateString('fr-FR', { 
            weekday: 'long', 
            year: 'numeric', 
            month: 'long', 
            day: 'numeric' 
        })}`;
    } else if (currentView === 'resourceTimelineWeek') {
        const endDate = new Date(viewEnd);
        endDate.setDate(endDate.getDate() - 1);
        
        periodTitle = `Semaine: ${viewStart.toLocaleDateString('fr-FR', { 
            day: 'numeric', 
            month: 'short' 
        })} - ${endDate.toLocaleDateString('fr-FR', { 
            day: 'numeric', 
            month: 'short', 
            year: 'numeric' 
        })}`;
    }
    
    const calendarBody = document.querySelector('#calendar .fc-view-harness');
    const calendarElement = calendarBody || document.getElementById('calendar');

    html2canvas(calendarElement, {
        scale: 2,
        useCORS: true,
        backgroundColor: '#ffffff',
        width: calendarElement.scrollWidth,
        height: calendarElement.scrollHeight
    }).then(function(canvas) {
        const printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <html>
                <head>
                    <title>Planning - ${periodTitle}</title>
                    <style>
                    @page  {
                            size: landscape;
                            margin: 0.5in;
                        }
                        body { 
                            margin: 0; 
                            padding: 20px; 
                            background: white; 
                            text-align: center;
                            font-family: Arial, sans-serif;
                        }
                        .period-title {
                            font-size: 24px;
                            font-weight: bold;
                            margin-bottom: 15px;
                            color: #035082;
                        }
                        .generated-info {
                            font-size: 12px;
                            color: #666;
                            margin-bottom: 20px;
                        }
                        img { 
                            max-width: 100%; 
                            height: auto; 
                        }
                        @media  print { 
                            body { padding: 0; } 
                            img { width: 100%; } 
                        }
                    </style>
                </head>
                <body>
                    <div class="period-title">Planning - ${periodTitle}</div>
                    
                    <img src="${canvas.toDataURL('image/png')}" alt="Planning">
                    <scr` + `ipt>
                        window.onload = function() { window.print(); };
                    </scr` + `ipt>
                </body>
            </html>`);
        printWindow.document.close();
    });
}

// <div class="generated-info">
//                         Généré le ${new Date().toLocaleDateString('fr-FR')} à ${new Date().toLocaleTimeString('fr-FR')}
//                     </div>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/timeline-employees.blade.php ENDPATH**/ ?>