<?php $__env->startSection('title'); ?> Gestion des Familles <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="intro-y  mb-3 flex items-center">
	<div class="row">

		<div class="col-8 mb-4 mb-xl-0">
		    <h2 class="mr-auto text-lg font-medium">Gestion des Familles</h2>
		</div>


		<div class="col-4">
			<div class="justify-content-end d-flex">
				<a href="<?php echo e(route('admin.add-famille')); ?>" class="btn btn-primary mr-2">Ajouter Famille</a>
			</div>			 
		</div>

	</div>
</div>

<br>


<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table class="table table-striped table-borderless  datatables" id="table1" >
                <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Nom</th>
                    <th>Lieu</th>
                    <th>Elements</th>
                    <th>Action</th>
                </tr>  
                </thead>
                <tbody>
                <?php $i=1; ?>
                <?php $__currentLoopData = $familles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $famille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	              <tr>
	                <td><?php echo e($i++); ?></td>
                    <td>
                        <?php if($famille->image): ?>
							<?php $photos = json_decode($famille->image); ?>
							<?php if(!empty($photos) && isset($photos[0]) && file_exists(public_path('uploads/' . $photos[0]))): ?>
								<img src="<?php echo e(asset('uploads/' . $photos[0])); ?>" alt="Photo" class="img-fluid rounded" height="200" width="auto"/>
							<?php else: ?>
								<img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="img-fluid rounded" height="200" width="auto"/>
							<?php endif; ?>
						<?php else: ?>
							<img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="img-fluid rounded" height="200" width="auto"/>
						<?php endif; ?>
                    </td>
	                <td class="font-weight-bold"><?php echo e($famille->nom ?? ''); ?></td>
					<?php $lieu = \App\Models\Lieu::find($famille->lieu); ?>
					
	                <td class="font-weight-medium">
                        <?php if($lieu): ?>
                            <a href="<?php echo e(route('admin.edit-lieu', $lieu->id)); ?>"><?php echo e($lieu->lieu ?? ''); ?></a>
                        <?php else: ?>
                            <span class="text-muted">Non défini</span>
                        <?php endif; ?>
                    </td>

					<td class="font-weight-medium">
					
						<?php if(!empty($famille->elements)): ?>
						<?php
						$elements = json_decode($famille->elements);
						foreach($elements as $elt){
							$element = \App\Models\Element::find($elt);
							if($element)
							echo "<span class='badge badge-primary text-white mr-1'>".$element->element ?? ''."</span>, ";
						}
						
						?>
						<?php endif; ?>
					</td>

	                <td>
					<a href='<?php echo e(route("admin.famille-details", $famille->id)); ?>' class="text-success mr-2"><i class="fa-solid fa-eye"></i> Details </a>

					<a href='<?php echo e(route("admin.edit-famille",$famille->id)); ?>' class="text-info  mr-2"><i class="fa-solid fa-pen-to-square"></i> Modifier </a>
					<a data-id="<?php echo e($famille->id); ?>" class="text-danger delete" href="javascript::void();"><i class="fa-solid fa-pen-to-square"></i> Supprimer </a>
					
						
	                </td>
	              </tr>
	              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
                </tbody>
            </table>
            </div>
        </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>



<script>
	$('.delete').click(function(){
		var dataId = $(this).attr("data-id");
		Swal.fire({
		  title: "Êtes-vous sûr?",
		  text: "Une fois que vous confirmez, cette action ne peut plus être annulée!",
		  icon: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#3085d6",
		  cancelButtonColor: "#d33",
		  confirmButtonText: "Oui, supprime-le!"
		}).then((result) => {
		  if (result.isConfirmed) {
		    Swal.fire({
		      title: "Supprimé!",
		      text: "La suppression est réussie.",
		      icon: "success"
		    });
		    window.open("<?php echo e(route('admin.delete-famille', ['id' => 'dataId'])); ?>".replace('dataId', dataId),"_self");
		  }
		});
	});
</script>



<script>
  $('#table1').DataTable({
        dom: 'Bfrtip',
        language: {
            url: '<?php echo e(asset("assets/fr-FR.json")); ?>'
        },
        pageLength: 10, // Default number of rows per page
        lengthMenu: [ [10, 25, 50, -1], [10, 25, 50, "All"] ],
        buttons: [
            {
				title:'Liste des Familles',
                extend: 'copy',
                exportOptions: {
                    columns: [0, 2, 3, 4]
                }
            },
            {
				title:'Liste des Familles',
                extend: 'csv',
                exportOptions: {
                    columns: [0, 2, 3, 4]
                }
            },
            {
				title:'Liste des Familles',
                extend: 'excel',
                exportOptions: {
                    columns: [0, 2, 3, 4]
                }
            },
            {
				title:'Liste des Familles',
                extend: 'pdf',
				text: 'PDF',
                exportOptions: {
					modifier: {
                    page: 'current'
                },
                    columns: [0, 2, 3, 4]
                }
            },
            {
				title: '<h2 style="text-align: center;">Liste des Familles</h2>', // Title centered
				extend: 'print',
				exportOptions: {
					columns: [0, 2, 3, 4]
				},
				customize: function (win) {
					$(win.document.body)
						.css('font-size', '10pt') // Optional: Adjust font size
						.prepend(
							'<div style="text-align: center;"><img src="<?php echo e(asset('assets/images/RenovImmo-long.png')); ?>" style="width: 100%; margin-bottom: 20px;" /></div>'
						);

					// Style the title
					$(win.document.body).find('h1')
						.css('text-align', 'center') // Ensure the title is centered
						.css('margin-bottom', '50px'); // Optional: Add spacing below the title
						
						
					// Style the table explicitly
					$(win.document.body).find('table').addClass('table table-bordered table-striped');
				}
			},

            'colvis'
        ]
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/krgysgq/renovimmo/resources/views/admin/familles.blade.php ENDPATH**/ ?>