<?php $__env->startSection('title'); ?> Modifier Chantier <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<style>

.img-chantier {
    width: auto;
}
</style>


<div class="page-title">
    <div class="row mb-3">
        <div class="col-12 col-md-6 order-md-1 order-last">
        <h2 class="mr-auto text-lg font-medium">Modifier Chantier</h2>
        </div>
        <div class="col-12 col-md-6 order-md-2 order-first">
            <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="/admin/chantiers">Chantiers</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Modifier Chantier
                    </li>
                </ol>
            </nav>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        
        <form method="post" enctype="multipart/form-data" autocomplete="off" action="<?php echo e(route('admin.update-chantier')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" value="<?php echo e($chantier->id); ?>">
        <div class="form-group">
            <label for="nom">Nom Chantier</label>
            <input name="nom" id="nom" value="<?php echo e($chantier->nom); ?>" type="text" class="form-control" required>
        </div>
        
        <div class="form-group">
            <label for="adresse">Adresse</label>
            <input name="adresse" id="adresse" type="text" class="form-control" value="<?php echo e($chantier->adresse); ?>" required>
        </div>

        <div class="form-group">
            <label for="date_de_debut">Date de debut</label>
            <input name="date_de_debut" id="date_de_debut" type="date" min=0 class="form-control" value="<?php echo e($chantier->date_de_debut); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="date_de_fin">Date Fin Programmée</label>
            <input name="date_de_fin" id="date_de_fin" type="date" min=0 class="form-control" value="<?php echo e($chantier->date_de_fin); ?>" required>
        </div>
        
        
        <div class="form-group">
            <label for="date_fin_reelle">Date Fin Réelle</label>
            <input name="date_fin_reelle" id="date_fin_reelle" type="date" min=0 class="form-control" value="<?php echo e($chantier->date_fin_reelle); ?>">
        </div>
        


        <div class="form-group">
                <label for="photos">Photos</label>
                <div class="d-flex flex-wrap mb-2">
                    <?php if($chantier->photo): ?>
                        <?php $__currentLoopData = $chantier->photo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(file_exists(public_path('uploads/' . $photo))): ?>
                                <img src="<?php echo e(asset('uploads/' . $photo)); ?>" alt="Photo" class="rounded mr-1" height="200" width="auto"/>
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Image" class="rounded mr-1" height="200" width="auto"/>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/images/no_image.png')); ?>" alt="No Images" class="rounded" height="200" width="auto"/>
                    <?php endif; ?>
                </div>
            
            <input type="file" name="photos[]" multiple class="image-preview-filepond filepond" id="photo-input">
            <div id="photo-preview" class="d-flex flex-wrap mt-2"></div> <!-- Preview container -->
        </div>


            
        
        <button type="submit" class="btn btn-primary mr-2">Mettre à jour</button>
        <button type="reset" class="btn btn-light">Réinitialiser</button>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>
<script>
    document.getElementById('photo-input').addEventListener('change', function(event) {
        const previewContainer = document.getElementById('photo-preview');
        previewContainer.innerHTML = ''; // Clear previous previews

        const files = event.target.files;
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Preview';
                    img.className = 'img-chantier rounded mr-2 mb-2';
                    img.height = 200; // Set height to 200
                    img.width = 200; // Set width to auto
                    previewContainer.appendChild(img); // Append to preview container
                }
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u400861240/domains/zydevgroup.com/public_html/renovimmo/resources/views/admin/edit-chantier.blade.php ENDPATH**/ ?>